/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mayo;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.mayo.GF16Utils;
import org.bouncycastle.pqc.crypto.mayo.MayoKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mayo.MayoParameters;
import org.bouncycastle.pqc.crypto.mayo.MayoPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mayo.MayoPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mayo.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.GF16;
import org.bouncycastle.util.Longs;

public class MayoKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private MayoParameters p;
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        this.p = ((MayoKeyGenerationParameters)param).getParameters();
        this.random = param.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int mVecLimbs = this.p.getMVecLimbs();
        int m = this.p.getM();
        int v = this.p.getV();
        int o = this.p.getO();
        int oBytes = this.p.getOBytes();
        int p1Limbs = this.p.getP1Limbs();
        int p3Limbs = this.p.getP3Limbs();
        int pkSeedBytes = this.p.getPkSeedBytes();
        int skSeedBytes = this.p.getSkSeedBytes();
        byte[] cpk = new byte[this.p.getCpkBytes()];
        byte[] seed_sk = new byte[this.p.getCskBytes()];
        byte[] seed_pk = new byte[pkSeedBytes + oBytes];
        long[] P = new long[p1Limbs + this.p.getP2Limbs()];
        long[] P3 = new long[o * o * mVecLimbs];
        byte[] O = new byte[v * o];
        this.random.nextBytes(seed_sk);
        SHAKEDigest shake = new SHAKEDigest(256);
        shake.update(seed_sk, 0, skSeedBytes);
        shake.doFinal(seed_pk, 0, pkSeedBytes + oBytes);
        GF16.decode(seed_pk, pkSeedBytes, O, 0, O.length);
        Utils.expandP1P2(this.p, P, seed_pk);
        GF16Utils.mulAddMUpperTriangularMatXMat(mVecLimbs, P, O, P, p1Limbs, v, o);
        GF16Utils.mulAddMatTransXMMat(mVecLimbs, O, P, p1Limbs, P3, v, o);
        System.arraycopy(seed_pk, 0, cpk, 0, pkSeedBytes);
        long[] P3_upper = new long[p3Limbs];
        int mVecsStored = 0;
        int omVecLimbs = o * mVecLimbs;
        int r = 0;
        int rmVecLimbs = 0;
        int romVecLimbs = 0;
        while (r < o) {
            int c = r;
            int cmVecLimbs = rmVecLimbs;
            int comVecLimbs = romVecLimbs;
            while (c < o) {
                System.arraycopy(P3, romVecLimbs + cmVecLimbs, P3_upper, mVecsStored, mVecLimbs);
                if (r != c) {
                    Longs.xorTo(mVecLimbs, P3, comVecLimbs + rmVecLimbs, P3_upper, mVecsStored);
                }
                mVecsStored += mVecLimbs;
                ++c;
                cmVecLimbs += mVecLimbs;
                comVecLimbs += omVecLimbs;
            }
            ++r;
            romVecLimbs += omVecLimbs;
            rmVecLimbs += mVecLimbs;
        }
        Utils.packMVecs(P3_upper, cpk, pkSeedBytes, p3Limbs / mVecLimbs, m);
        Arrays.clear(O);
        Arrays.clear(P3);
        return new AsymmetricCipherKeyPair(new MayoPublicKeyParameters(this.p, cpk), new MayoPrivateKeyParameters(this.p, seed_sk));
    }
}

