/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mayo;

import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CTRModeCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.pqc.crypto.mayo.MayoParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class Utils {
    Utils() {
    }

    public static void unpackMVecs(byte[] in, int inOff, long[] out, int outOff, int vecs, int m) {
        int mVecLimbs = m + 15 >> 4;
        int bytesToCopy = m >> 1;
        int lastblockLen = 8 - (mVecLimbs << 3) + bytesToCopy;
        int i = vecs - 1;
        outOff += i * mVecLimbs;
        inOff += i * bytesToCopy;
        while (i >= 0) {
            int j;
            for (j = 0; j < mVecLimbs - 1; ++j) {
                out[outOff + j] = Pack.littleEndianToLong(in, inOff + (j << 3));
            }
            out[outOff + j] = Pack.littleEndianToLong(in, inOff + (j << 3), lastblockLen);
            --i;
            outOff -= mVecLimbs;
            inOff -= bytesToCopy;
        }
    }

    public static void packMVecs(long[] in, byte[] out, int outOff, int vecs, int m) {
        int mVecLimbs = m + 15 >> 4;
        int bytesToCopy = m >> 1;
        int lastBlockLen = 8 - (mVecLimbs << 3) + bytesToCopy;
        int i = 0;
        int inOff = 0;
        while (i < vecs) {
            int j;
            for (j = 0; j < mVecLimbs - 1; ++j) {
                Pack.longToLittleEndian(in[inOff + j], out, outOff + (j << 3));
            }
            Pack.longToLittleEndian(in[inOff + j], out, outOff + (j << 3), lastBlockLen);
            ++i;
            outOff += bytesToCopy;
            inOff += mVecLimbs;
        }
    }

    public static void expandP1P2(MayoParameters p, long[] P, byte[] seed_pk) {
        int outLen = p.getP1Bytes() + p.getP2Bytes();
        byte[] temp = new byte[outLen];
        byte[] iv = new byte[16];
        MultiBlockCipher aesEngine = AESEngine.newInstance();
        CTRModeCipher ctrCipher = SICBlockCipher.newInstance(aesEngine);
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(Arrays.copyOf(seed_pk, p.getPkSeedBytes())), iv);
        ctrCipher.init(true, params);
        int blockSize = ctrCipher.getBlockSize();
        byte[] zeroBlock = new byte[blockSize];
        byte[] blockOut = new byte[blockSize];
        int offset = 0;
        while (offset + blockSize <= outLen) {
            ctrCipher.processBlock(zeroBlock, 0, blockOut, 0);
            System.arraycopy(blockOut, 0, temp, offset, blockSize);
            offset += blockSize;
        }
        if (offset < outLen) {
            ctrCipher.processBlock(zeroBlock, 0, blockOut, 0);
            int remaining = outLen - offset;
            System.arraycopy(blockOut, 0, temp, offset, remaining);
        }
        int numVectors = (p.getP1Limbs() + p.getP2Limbs()) / p.getMVecLimbs();
        Utils.unpackMVecs(temp, 0, P, 0, numVectors, p.getM());
    }
}

