/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.hqc;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.bouncycastle.pqc.crypto.hqc.HQCKEMExtractor;
import org.bouncycastle.pqc.crypto.hqc.HQCKEMGenerator;
import org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.hqc.BCHQCPublicKey;
import org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import org.bouncycastle.util.Arrays;

public class HQCKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;
    private HQCParameters hqcParameters;

    public HQCKeyGeneratorSpi() {
        this(null);
    }

    public HQCKeyGeneratorSpi(HQCParameters hqcParameters) {
        this.hqcParameters = hqcParameters;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            String canonicalAlgName;
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
            if (this.hqcParameters != null && !(canonicalAlgName = HQCParameterSpec.fromName(this.hqcParameters.getName()).getName()).equals(this.genSpec.getPublicKey().getAlgorithm())) {
                throw new InvalidAlgorithmParameterException("key generator locked to " + canonicalAlgName);
            }
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            String canonicalAlgName;
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
            if (this.hqcParameters != null && !(canonicalAlgName = HQCParameterSpec.fromName(this.hqcParameters.getName()).getName()).equals(this.extSpec.getPrivateKey().getAlgorithm())) {
                throw new InvalidAlgorithmParameterException("key generator locked to " + canonicalAlgName);
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int i, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCHQCPublicKey pubKey = (BCHQCPublicKey)this.genSpec.getPublicKey();
            HQCKEMGenerator kemGen = new HQCKEMGenerator(this.random);
            SecretWithEncapsulation secEnc = kemGen.generateEncapsulated(pubKey.getKeyParams());
            SecretKeyWithEncapsulation rv = new SecretKeyWithEncapsulation(new SecretKeySpec(secEnc.getSecret(), this.genSpec.getKeyAlgorithmName()), secEnc.getEncapsulation());
            try {
                secEnc.destroy();
            }
            catch (DestroyFailedException e) {
                throw new IllegalStateException("key cleanup failed");
            }
            return rv;
        }
        BCHQCPrivateKey privKey = (BCHQCPrivateKey)this.extSpec.getPrivateKey();
        HQCKEMExtractor kemExt = new HQCKEMExtractor(privKey.getKeyParams());
        byte[] encapsulation = this.extSpec.getEncapsulation();
        byte[] secret = kemExt.extractSecret(encapsulation);
        SecretKeyWithEncapsulation rv = new SecretKeyWithEncapsulation(new SecretKeySpec(secret, this.extSpec.getKeyAlgorithmName()), encapsulation);
        Arrays.clear(secret);
        return rv;
    }

    public static class HQC256
    extends HQCKeyGeneratorSpi {
        public HQC256() {
            super(HQCParameters.hqc256);
        }
    }

    public static class HQC192
    extends HQCKeyGeneratorSpi {
        public HQC192() {
            super(HQCParameters.hqc192);
        }
    }

    public static class HQC128
    extends HQCKeyGeneratorSpi {
        public HQC128() {
            super(HQCParameters.hqc128);
        }
    }
}

