/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mayo;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mayo.MayoParameters;
import org.bouncycastle.pqc.crypto.mayo.MayoPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mayo.MayoSigner;
import org.bouncycastle.pqc.jcajce.provider.mayo.BCMayoPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.mayo.BCMayoPublicKey;
import org.bouncycastle.util.Strings;

public class SignatureSpi
extends Signature {
    private final ByteArrayOutputStream bOut;
    private final MayoSigner signer;
    private SecureRandom random;
    private final MayoParameters parameters;

    protected SignatureSpi(MayoSigner signer) {
        super("Mayo");
        this.bOut = new ByteArrayOutputStream();
        this.signer = signer;
        this.parameters = null;
    }

    protected SignatureSpi(MayoSigner signer, MayoParameters parameters) {
        super(Strings.toUpperCase(parameters.getName()));
        this.parameters = parameters;
        this.bOut = new ByteArrayOutputStream();
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        String canonicalAlg;
        if (!(publicKey instanceof BCMayoPublicKey)) {
            try {
                publicKey = new BCMayoPublicKey(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
            }
            catch (Exception e) {
                throw new InvalidKeyException("unknown public key passed to Mayo: " + e.getMessage());
            }
        }
        BCMayoPublicKey key = (BCMayoPublicKey)publicKey;
        if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
            throw new InvalidKeyException("signature configured for " + canonicalAlg);
        }
        this.signer.init(false, key.getKeyParams());
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCMayoPrivateKey) {
            String canonicalAlg;
            BCMayoPrivateKey key = (BCMayoPrivateKey)privateKey;
            MayoPrivateKeyParameters param = key.getKeyParams();
            if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
                throw new InvalidKeyException("signature configured for " + canonicalAlg);
            }
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(param, this.random));
            } else {
                this.signer.init(true, param);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Mayo");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.bOut.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.bOut.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] message = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(message);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] message = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Mayo5
    extends SignatureSpi {
        public Mayo5() {
            super(new MayoSigner(), MayoParameters.mayo5);
        }
    }

    public static class Mayo3
    extends SignatureSpi {
        public Mayo3() {
            super(new MayoSigner(), MayoParameters.mayo3);
        }
    }

    public static class Mayo2
    extends SignatureSpi {
        public Mayo2() {
            super(new MayoSigner(), MayoParameters.mayo2);
        }
    }

    public static class Mayo1
    extends SignatureSpi {
        public Mayo1() {
            super(new MayoSigner(), MayoParameters.mayo1);
        }
    }

    public static class Base
    extends SignatureSpi {
        public Base() {
            super(new MayoSigner());
        }
    }
}

