/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.assembly;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFile;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

class AssemblyConfigurationUtils {
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String DEFAULT_NAME = "maven";
    private static final String DEFAULT_USER = "root";

    private AssemblyConfigurationUtils() {
    }

    @Nonnull
    static AssemblyConfiguration getAssemblyConfigurationOrCreateDefault(@Nullable BuildConfiguration buildConfiguration) {
        String name;
        AssemblyConfiguration ac = Optional.ofNullable(buildConfiguration).map(BuildConfiguration::getAssembly).orElse(AssemblyConfiguration.builder().user(DEFAULT_USER).build());
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = ac.toBuilder();
        if (StringUtils.isBlank((CharSequence)ac.getName())) {
            builder.name(DEFAULT_NAME);
            name = DEFAULT_NAME;
        } else {
            name = ac.getName();
        }
        if (StringUtils.isBlank((CharSequence)ac.getTargetDir())) {
            builder.targetDir(LINUX_FILE_SEPARATOR.concat(name));
        }
        return builder.build();
    }

    @Nonnull
    static List<AssemblyFileSet> getJKubeAssemblyFileSets(@Nullable AssemblyConfiguration configuration) {
        return Optional.ofNullable(configuration).map(AssemblyConfiguration::getInline).map(Assembly::getFileSets).orElse(Collections.emptyList());
    }

    @Nonnull
    static List<AssemblyFile> getJKubeAssemblyFiles(AssemblyConfiguration configuration) {
        return Optional.ofNullable(configuration).map(AssemblyConfiguration::getInline).map(Assembly::getFiles).orElse(Collections.emptyList());
    }
}

