/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.assembly;

import java.io.File;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;

public class BuildDirs {
    private final String buildTopDir;
    private final JKubeConfiguration params;

    public BuildDirs(String imageName, JKubeConfiguration params) {
        this.params = params;
        this.buildTopDir = imageName != null ? imageName.replace(':', '/') : null;
    }

    public File getOutputDirectory() {
        return this.getDir("build");
    }

    public File getWorkingDirectory() {
        return this.getDir("work");
    }

    public File getTemporaryRootDirectory() {
        return this.getDir("tmp");
    }

    void createDirs() {
        for (String workDir : new String[]{"build", "work", "tmp"}) {
            File dir = this.getDir(workDir);
            if (dir.exists() || dir.mkdirs()) continue;
            throw new IllegalArgumentException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    private File getDir(String dir) {
        return EnvUtil.prepareAbsoluteOutputDirPath((String)this.params.getOutputDirectory(), (String)(this.params.getProject().getBaseDirectory() != null ? this.params.getProject().getBaseDirectory().toString() : null), (String)this.buildTopDir, (String)dir);
    }
}

