/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jkube.kit.build.api.helper.JKubeDockerfileInterpolator;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.yaml.snakeyaml.Yaml;

public class DockerFileUtil {
    private DockerFileUtil() {
    }

    public static List<String> extractBaseImages(File dockerFile, Properties properties, String filter) throws IOException {
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", properties, filter);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> fromAlias = new HashSet<String>();
        for (String[] fromLine : fromLines) {
            if (fromLine.length <= 1) continue;
            if (fromLine.length == 2) {
                result.add(fromLine[1]);
                continue;
            }
            if (fromLine.length != 4) continue;
            if (!fromAlias.contains(fromLine[1])) {
                result.add(fromLine[1]);
            }
            fromAlias.add(fromLine[3]);
        }
        return new ArrayList<String>(result);
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, Properties properties, String filter) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = JKubeDockerfileInterpolator.interpolate(line, properties, filter);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, Properties properties, String filter) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(JKubeDockerfileInterpolator.interpolate(line, properties, filter)).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    private static Reader getFileReaderFromDir(File file) {
        if (file.exists() && file.length() != 0L) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find " + file, e);
            }
        }
        return null;
    }

    public static JsonObject readDockerConfig() {
        String dockerConfig = System.getenv("DOCKER_CONFIG");
        Reader reader = dockerConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".docker/config.json")) : DockerFileUtil.getFileReaderFromDir(new File(dockerConfig, "config.json"));
        return reader != null ? (JsonObject)new Gson().fromJson(reader, JsonObject.class) : null;
    }

    public static String[] extractDelimiters(String filter) {
        Matcher matcher;
        if (filter == null || filter.equalsIgnoreCase("false") || filter.equalsIgnoreCase("none")) {
            return new String[0];
        }
        if (filter.contains("*") && (matcher = Pattern.compile("^(?<start>[^*]+)\\*(?<end>.*)$").matcher(filter)).matches()) {
            return new String[]{matcher.group("start"), matcher.group("end")};
        }
        return new String[]{filter, filter};
    }

    public static Map<String, ?> readKubeConfig() {
        Reader reader;
        String kubeConfig = System.getenv("KUBECONFIG");
        Reader reader2 = reader = kubeConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".kube/config")) : DockerFileUtil.getFileReaderFromDir(new File(kubeConfig));
        if (reader != null) {
            Yaml ret = new Yaml();
            return (Map)ret.load(reader);
        }
        return null;
    }

    public static boolean isSimpleDockerFileMode(File projectBaseDirectory) {
        if (projectBaseDirectory != null) {
            return DockerFileUtil.getTopLevelDockerfile(projectBaseDirectory).exists();
        }
        return false;
    }

    public static File getTopLevelDockerfile(File projectBaseDirectory) {
        return new File(projectBaseDirectory, "Dockerfile");
    }

    public static ImageConfiguration createSimpleDockerfileConfig(File dockerFile, String defaultImageName) {
        if (defaultImageName == null) {
            defaultImageName = "%g/%a:%l";
        }
        BuildConfiguration buildConfig = BuildConfiguration.builder().dockerFile(dockerFile.getPath()).build();
        return ImageConfiguration.builder().name(defaultImageName).build(buildConfig).build();
    }

    public static ImageConfiguration addSimpleDockerfileConfig(ImageConfiguration image, File dockerfile) {
        BuildConfiguration buildConfig = BuildConfiguration.builder().dockerFile(dockerfile.getPath()).build();
        return image.toBuilder().build(buildConfig).build();
    }

    private static File getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            homeDir = System.getenv("HOME");
        }
        return new File(homeDir);
    }
}

