/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.eclipse.jkube.kit.common.JsonFactory;

public class VolumeCreateConfig {
    private final JsonObject createConfig = new JsonObject();

    public VolumeCreateConfig(String name) {
        this.add("Name", name);
    }

    public VolumeCreateConfig driver(String driver) {
        return this.add("Driver", driver);
    }

    public VolumeCreateConfig opts(Map<String, String> opts) {
        if (opts != null && opts.size() > 0) {
            this.add("DriverOpts", JsonFactory.newJsonObject(opts));
        }
        return this;
    }

    public VolumeCreateConfig labels(Map<String, String> labels) {
        if (labels != null && labels.size() > 0) {
            this.add("Labels", JsonFactory.newJsonObject(labels));
        }
        return this;
    }

    public String getName() {
        return this.createConfig.get("Name").getAsString();
    }

    public String toJson() {
        return this.createConfig.toString();
    }

    private VolumeCreateConfig add(String name, JsonObject value) {
        if (value != null) {
            this.createConfig.add(name, (JsonElement)value);
        }
        return this;
    }

    private VolumeCreateConfig add(String name, String value) {
        if (value != null) {
            this.createConfig.addProperty(name, value);
        }
        return this;
    }
}

