/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import com.google.common.base.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.MavenConfigurationExtractor;

public class MavenUtil {
    private static final String DEFAULT_CONFIG_FILE_NAME = "kubernetes.json";

    private MavenUtil() {
    }

    public static boolean isKubernetesJsonArtifact(String classifier, String type) {
        return "json".equals(type) && "kubernetes".equals(classifier);
    }

    public static boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals(DEFAULT_CONFIG_FILE_NAME)) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }

    public static URLClassLoader getCompileClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getCompileClasspathElements();
            return ClassUtil.createClassLoader((List)classpathElements, (String[])new String[]{project.getBuild().getOutputDirectory()});
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalArgumentException("Cannot resolve artifact from compile classpath", e);
        }
    }

    public static boolean hasDependency(MavenProject project, String groupId, String artifactId) {
        return MavenUtil.getDependencyVersion(project, groupId, artifactId) != null;
    }

    public static String getDependencyVersion(MavenProject project, String groupId, String artifactId) {
        Set artifacts = project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                String scope = artifact.getScope();
                if (Objects.equal((Object)"test", (Object)scope) || artifactId != null && !Objects.equal((Object)artifactId, (Object)artifact.getArtifactId()) || !Objects.equal((Object)groupId, (Object)artifact.getGroupId())) continue;
                return artifact.getVersion();
            }
        }
        return null;
    }

    public static boolean hasPlugin(MavenProject project, String groupId, String artifactId) {
        return project.getPlugin(groupId + ":" + artifactId) != null;
    }

    public static boolean hasPluginOfAnyGroupId(MavenProject project, String pluginArtifact) {
        return MavenUtil.getPluginOfAnyGroupId(project, pluginArtifact) != null;
    }

    public static org.apache.maven.model.Plugin getPluginOfAnyGroupId(MavenProject project, String pluginArtifact) {
        return MavenUtil.getPlugin(project, null, pluginArtifact);
    }

    public static List<Plugin> getPlugins(MavenProject project) {
        ArrayList<Plugin> projectPlugins = new ArrayList<Plugin>();
        for (org.apache.maven.model.Plugin plugin : project.getBuildPlugins()) {
            Plugin.PluginBuilder jkubeProjectPluginBuilder = Plugin.builder();
            jkubeProjectPluginBuilder.groupId(plugin.getGroupId()).artifactId(plugin.getArtifactId()).version(plugin.getVersion());
            if (plugin.getExecutions() != null && !plugin.getExecutions().isEmpty()) {
                jkubeProjectPluginBuilder.executions(MavenUtil.getPluginExecutionsAsList(plugin));
            }
            jkubeProjectPluginBuilder.configuration(MavenConfigurationExtractor.extract((Xpp3Dom)plugin.getConfiguration()));
            projectPlugins.add(jkubeProjectPluginBuilder.build());
        }
        return projectPlugins;
    }

    public static List<String> getPluginExecutionsAsList(org.apache.maven.model.Plugin plugin) {
        ArrayList<String> pluginExecutions = new ArrayList<String>();
        for (PluginExecution pluginExecution : plugin.getExecutions()) {
            pluginExecutions.addAll(pluginExecution.getGoals());
        }
        return pluginExecutions;
    }

    public static List<Dependency> getTransitiveDependencies(MavenProject project) {
        return project.getArtifacts().stream().map(a -> Dependency.builder().groupId(a.getGroupId()).artifactId(a.getArtifactId()).version(a.getVersion()).type(a.getType()).scope(a.getScope()).file(a.getFile()).build()).collect(Collectors.toList());
    }

    public static List<Dependency> getDependencies(MavenProject project) {
        return project.getDependencies().stream().map(d -> Dependency.builder().groupId(d.getGroupId()).artifactId(d.getArtifactId()).version(d.getVersion()).type(d.getType()).scope(d.getScope()).build()).collect(Collectors.toList());
    }

    public static org.apache.maven.model.Plugin getPlugin(MavenProject project, String groupId, String artifactId) {
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        List plugins = project.getBuildPlugins();
        if (plugins != null) {
            for (org.apache.maven.model.Plugin plugin : plugins) {
                boolean matchesArtifactId = artifactId.equals(plugin.getArtifactId());
                boolean matchesGroupId = groupId == null || groupId.equals(plugin.getGroupId());
                if (!matchesGroupId || !matchesArtifactId) continue;
                return plugin;
            }
        }
        return null;
    }

    public static boolean hasResource(MavenProject project, String ... paths) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        for (String path : paths) {
            try {
                if (compileClassLoader.getResource(path) == null) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void createArchive(File sourceDir, File destinationFile, TarArchiver archiver) throws IOException {
        try {
            archiver.setCompression(TarArchiver.TarCompressionMethod.gzip);
            archiver.setLongfile(TarLongFileMode.posix);
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new IOException("Failed to create archive " + destinationFile + ": " + e, e);
        }
    }

    public static void createArchive(File sourceDir, File destinationFile, ZipArchiver archiver) throws IOException {
        try {
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new IOException("Failed to create archive " + destinationFile + ": " + e, e);
        }
    }

    public static String getVersion(String groupId, String artifactId) throws IOException {
        String path = String.format("META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
        InputStream in = MavenUtil.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new IOException("Could not find " + path + " on classath!");
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            throw new IOException("Failed to load " + path + ". " + e, e);
        }
        String version = properties.getProperty("version");
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IOException("No version property in " + path);
        }
        return version;
    }

    public static Properties getPropertiesWithSystemOverrides(MavenProject project) {
        Properties properties = new Properties(project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static boolean isMaven350OrLater(MavenSession mavenSession) {
        String mavenVersion = mavenSession.getSystemProperties().getProperty("maven.version", "3");
        return EnvUtil.greaterOrEqualsVersion((String)mavenVersion, (String)"3.5.0");
    }

    public static String getDocumentationUrl(MavenProject project) {
        while (project != null) {
            Site site;
            DistributionManagement distributionManagement = project.getDistributionManagement();
            if (distributionManagement != null && (site = distributionManagement.getSite()) != null) {
                return site.getUrl();
            }
            project = project.getParent();
        }
        return null;
    }

    public static Optional<List<String>> getCompileClasspathElementsIfRequested(MavenProject project, boolean useProjectClasspath) throws IOException {
        if (!useProjectClasspath) {
            return Optional.empty();
        }
        try {
            return Optional.of(project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IOException("Cannot extract compile class path elements", e);
        }
    }

    public static List<RegistryServerConfiguration> getRegistryServerFromMavenSettings(Settings settings) {
        ArrayList<RegistryServerConfiguration> registryServerConfigurations = new ArrayList<RegistryServerConfiguration>();
        for (Server server : settings.getServers()) {
            if (server.getUsername() == null) continue;
            registryServerConfigurations.add(RegistryServerConfiguration.builder().id(server.getId()).username(server.getUsername()).password(server.getPassword()).configuration(MavenConfigurationExtractor.extract((Xpp3Dom)server.getConfiguration())).build());
        }
        return registryServerConfigurations;
    }

    public static JavaProject convertMavenProjectToJKubeProject(MavenProject mavenProject, MavenSession mavenSession) throws DependencyResolutionRequiredException {
        JavaProject.JavaProjectBuilder builder = JavaProject.builder();
        Properties properties = new Properties();
        File localRepositoryBaseDir = null;
        if (mavenProject.getProperties() != null) {
            properties.putAll((Map<?, ?>)mavenProject.getProperties());
        }
        if (mavenSession != null) {
            if (mavenSession.getLocalRepository().getBasedir() != null) {
                localRepositoryBaseDir = new File(mavenSession.getLocalRepository().getBasedir());
            }
            if (mavenSession.getUserProperties() != null) {
                properties.putAll((Map<?, ?>)mavenSession.getUserProperties());
            }
            if (mavenSession.getSystemProperties() != null) {
                properties.putAll((Map<?, ?>)mavenSession.getSystemProperties());
            }
            if (mavenSession.getExecutionProperties() != null) {
                properties.putAll((Map<?, ?>)mavenSession.getExecutionProperties());
            }
        }
        builder.name(mavenProject.getName()).description(mavenProject.getDescription()).groupId(mavenProject.getGroupId()).artifactId(mavenProject.getArtifactId()).version(mavenProject.getVersion()).baseDirectory(mavenProject.getBasedir()).documentationUrl(MavenUtil.getDocumentationUrl(mavenProject)).compileClassPathElements((Collection)mavenProject.getCompileClasspathElements()).properties(properties).packaging(mavenProject.getPackaging()).dependencies(MavenUtil.getDependencies(mavenProject)).dependenciesWithTransitive(MavenUtil.getTransitiveDependencies(mavenProject)).localRepositoryBaseDirectory(localRepositoryBaseDir).plugins(MavenUtil.getPlugins(mavenProject));
        if (mavenProject.getOrganization() != null) {
            builder.site(mavenProject.getOrganization().getUrl()).organizationName(mavenProject.getOrganization().getName());
        }
        Optional.ofNullable(mavenProject.getBuild()).ifPresent(mavenBuild -> builder.outputDirectory(new File(mavenBuild.getOutputDirectory())).buildFinalName(mavenBuild.getFinalName()).buildDirectory(new File(mavenBuild.getDirectory())));
        if (mavenProject.getIssueManagement() != null) {
            builder.issueManagementSystem(mavenProject.getIssueManagement().getSystem());
            builder.issueManagementUrl(mavenProject.getIssueManagement().getUrl());
        }
        if (mavenProject.getScm() != null) {
            builder.scmTag(mavenProject.getScm().getTag());
            builder.scmUrl(mavenProject.getScm().getUrl());
        }
        if (mavenProject.getArtifact() != null) {
            builder.artifact(mavenProject.getArtifact().getFile());
        }
        return builder.build();
    }
}

