/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HasMetadataComparator;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;

public class KubernetesHelper {
    protected static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    private static final String FILENAME_PATTERN_REGEX = "^(?<name>.*?)(-(?<type>[^-]+))?\\.(?<ext>yaml|yml|json)$";
    private static final String PROFILES_PATTERN_REGEX = "^profiles?\\.ya?ml$";
    public static final Pattern FILENAME_PATTERN = Pattern.compile("^(?<name>.*?)(-(?<type>[^-]+))?\\.(?<ext>yaml|yml|json)$", 2);
    public static final Pattern PROFILES_PATTERN = Pattern.compile("^profiles?\\.ya?ml$", 2);

    private KubernetesHelper() {
    }

    public static String validateKubernetesId(String currentValue, String description) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            throw new IllegalArgumentException("No " + description + " is specified!");
        }
        int size = currentValue.length();
        for (int i = 0; i < size; ++i) {
            char ch = currentValue.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            throw new IllegalArgumentException("Invalid upper case letter '" + ch + "' at index " + i + " for " + description + " value: " + currentValue);
        }
        return currentValue;
    }

    public static List<HasMetadata> toItemList(Object entity) throws IOException {
        if (entity instanceof List) {
            return (List)entity;
        }
        if (entity instanceof HasMetadata[]) {
            HasMetadata[] array = (HasMetadata[])entity;
            return Arrays.asList(array);
        }
        if (entity instanceof KubernetesList) {
            KubernetesList config = (KubernetesList)entity;
            return config.getItems();
        }
        if (entity instanceof Template) {
            Template objects = (Template)entity;
            return objects.getObjects();
        }
        ArrayList<HasMetadata> answer = new ArrayList<HasMetadata>();
        if (entity instanceof HasMetadata) {
            answer.add((HasMetadata)entity);
        }
        return answer;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && StringUtils.isNotBlank((CharSequence)(resourceVersion = metadata.getResourceVersion()))) {
            return resourceVersion;
        }
        return null;
    }

    public static Map<String, String> getLabels(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getLabels(entity.getMetadata());
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getName(entity.getMetadata());
        }
        return null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            for (String name : new String[]{entity.getName(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid()}) {
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                return name;
            }
        }
        return null;
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static String getKind(HasMetadata entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static IntOrString createIntOrString(int intVal) {
        IntOrString answer = new IntOrString();
        answer.setIntVal(Integer.valueOf(intVal));
        answer.setKind(Integer.valueOf(0));
        return answer;
    }

    public static IntOrString createIntOrString(String nameOrNumber) {
        if (StringUtils.isBlank((CharSequence)nameOrNumber)) {
            return null;
        }
        IntOrString answer = new IntOrString();
        Integer intVal = null;
        try {
            intVal = Integer.parseInt(nameOrNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (intVal != null) {
            answer.setIntVal(intVal);
            answer.setKind(Integer.valueOf(0));
        } else {
            answer.setStrVal(nameOrNumber);
            answer.setKind(Integer.valueOf(1));
        }
        return answer;
    }

    public static boolean isPodRunning(Pod pod) {
        return KubernetesHelper.isInPodPhase(pod, "run");
    }

    public static boolean isPodWaiting(Pod pod) {
        return KubernetesHelper.isInPodPhase(pod, "wait");
    }

    public static boolean isPodReady(Pod pod) {
        if (!KubernetesHelper.isPodRunning(pod)) {
            return false;
        }
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return true;
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (PodCondition condition : conditions) {
            if (!"ready".equalsIgnoreCase(condition.getType())) continue;
            return Boolean.parseBoolean(condition.getStatus());
        }
        return true;
    }

    private static boolean isInPodPhase(Pod pod, String phase) {
        return KubernetesHelper.getPodPhase(pod).toLowerCase().startsWith(phase);
    }

    public static String getPodPhase(Pod pod) {
        PodStatus podStatus;
        if (pod != null && (podStatus = pod.getStatus()) != null) {
            String actualPhase = podStatus.getPhase();
            return actualPhase != null ? actualPhase : "";
        }
        return "";
    }

    public static List<Container> getContainers(Pod pod) {
        if (pod != null) {
            PodSpec podSpec = pod.getSpec();
            return KubernetesHelper.getContainers(podSpec);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Container> getContainers(PodSpec podSpec) {
        if (podSpec != null) {
            return podSpec.getContainers();
        }
        return Collections.EMPTY_LIST;
    }

    private static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getDefaultNamespace() {
        String ns = new ConfigBuilder().build().getNamespace();
        return ns != null ? ns : "default";
    }

    public static String currentUserName() {
        String user;
        Context context;
        Config config = KubernetesHelper.parseConfigs();
        if (config != null && (context = KubernetesHelper.getCurrentContext(config)) != null && (user = context.getUser()) != null) {
            String[] parts = user.split("/");
            if (parts.length > 0) {
                return parts[0];
            }
            return user;
        }
        return null;
    }

    private static Config parseConfigs() {
        File file = KubernetesHelper.getKubernetesConfigFile();
        if (file.exists() && file.isFile()) {
            try {
                return ResourceUtil.load(file, Config.class, ResourceFileType.yaml);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Context getCurrentContext(Config config) {
        List contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!Objects.equals(contextName, context.getName())) continue;
                return context.getContext();
            }
        }
        return null;
    }

    private static File getKubernetesConfigFile() {
        String file = System.getProperty("kubernetes.config.file");
        if (file != null) {
            return new File(file);
        }
        file = System.getenv("KUBECONFIG");
        if (file != null) {
            return new File(file);
        }
        String homeDir = System.getProperty("user.home", ".");
        return new File(homeDir, ".kube/config");
    }

    public static void handleKubernetesClientException(KubernetesClientException e, KitLogger logger) throws IllegalStateException {
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException) {
            logger.error("Could not connect to kubernetes cluster!", new Object[0]);
            logger.error("Have you started a local cluster via `mvn jkube:cluster-start` or connected to a remote cluster via `kubectl`?", new Object[0]);
            logger.info("For more help see: http://jkube.io/guide/getStarted/", new Object[0]);
            logger.error("Connection error: %s", cause);
            String message = "Could not connect to kubernetes cluster. Have you started a cluster via `minikube start` or connected to a remote cluster via `kubectl`? Error: " + cause;
            throw new IllegalStateException(message, (Throwable)e);
        }
        throw new IllegalStateException(e.getMessage(), (Throwable)e);
    }

    public static Set<HasMetadata> loadResources(File manifest) throws IOException {
        KubernetesResource dto = ResourceUtil.load(manifest, KubernetesResource.class);
        if (dto == null) {
            throw new IllegalStateException("Cannot load kubernetes manifest " + manifest);
        }
        if (dto instanceof Template) {
            Template template = (Template)dto;
            dto = OpenshiftHelper.processTemplatesLocally(template, false);
        }
        TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
        entities.addAll(KubernetesHelper.toItemList(dto));
        return entities;
    }

    public static String getBuildStatusPhase(Build build) {
        if (build != null && build.getStatus() != null) {
            return build.getStatus().getPhase();
        }
        return null;
    }

    public static void printLogsAsync(LogWatch logWatcher, final String failureMessage, final CountDownLatch terminateLatch, final KitLogger log) {
        final InputStream in = logWatcher.getOutput();
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            return;
                        }
                        if (terminateLatch.getCount() <= 0L) {
                            return;
                        }
                        log.info("[[s]]%s", line);
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    if (terminateLatch.getCount() <= 0L) return;
                    log.error("%s : %s", failureMessage, e);
                    return;
                }
            }
        };
        thread.start();
    }

    public static String getBuildStatusReason(Build build) {
        if (build != null && build.getStatus() != null) {
            String reason = build.getStatus().getReason();
            String phase = build.getStatus().getPhase();
            if (StringUtils.isNotBlank((CharSequence)phase)) {
                if (StringUtils.isNotBlank((CharSequence)reason)) {
                    return phase + ": " + reason;
                }
                return phase;
            }
            return (String)StringUtils.defaultIfEmpty((CharSequence)reason, (CharSequence)"");
        }
        return "";
    }

    public static FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> withSelector(NonNamespaceOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods, LabelSelector selector, KitLogger log) {
        List matchExpressions;
        FilterWatchListDeletable answer = pods;
        Map matchLabels = selector.getMatchLabels();
        if (matchLabels != null && !matchLabels.isEmpty()) {
            answer = (FilterWatchListDeletable)answer.withLabels(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block8: for (LabelSelectorRequirement expression : matchExpressions) {
                String operator;
                String key = expression.getKey();
                List values = expression.getValues();
                if (StringUtils.isBlank((CharSequence)key)) {
                    log.warn("Ignoring empty key in selector expression %s", expression);
                    continue;
                }
                if (values == null || values.isEmpty()) {
                    log.warn("Ignoring empty values in selector expression %s", expression);
                    continue;
                }
                String[] valuesArray = values.toArray(new String[values.size()]);
                switch (operator = expression.getOperator()) {
                    case "In": {
                        answer = (FilterWatchListDeletable)answer.withLabelIn(key, valuesArray);
                        continue block8;
                    }
                    case "NotIn": {
                        answer = (FilterWatchListDeletable)answer.withLabelNotIn(key, valuesArray);
                        continue block8;
                    }
                }
                log.warn("Ignoring unknown operator %s in selector expression %s", operator, expression);
            }
        }
        return answer;
    }

    public static LabelSelector getPodLabelSelector(Set<HasMetadata> entities) {
        LabelSelector chosenSelector = null;
        for (HasMetadata entity : entities) {
            LabelSelector selector = KubernetesHelper.getPodLabelSelector(entity);
            if (selector == null) continue;
            if (chosenSelector != null && !chosenSelector.equals((Object)selector)) {
                throw new IllegalArgumentException("Multiple selectors found for the given entities: " + chosenSelector + " - " + selector);
            }
            chosenSelector = selector;
        }
        return chosenSelector;
    }

    public static LabelSelector getPodLabelSelector(HasMetadata entity) {
        Job resource;
        JobSpec spec;
        LabelSelector selector = null;
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null) {
                selector = spec2.getSelector();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null) {
                selector = spec3.getSelector();
            }
        } else if (entity instanceof DeploymentConfig) {
            DeploymentConfig resource4 = (DeploymentConfig)entity;
            DeploymentConfigSpec spec4 = resource4.getSpec();
            if (spec4 != null) {
                selector = KubernetesHelper.toLabelSelector(spec4.getSelector());
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource5 = (ReplicationController)entity;
            ReplicationControllerSpec spec5 = resource5.getSpec();
            if (spec5 != null) {
                selector = KubernetesHelper.toLabelSelector(spec5.getSelector());
            }
        } else if (entity instanceof DaemonSet) {
            DaemonSet resource6 = (DaemonSet)entity;
            DaemonSetSpec spec6 = resource6.getSpec();
            if (spec6 != null) {
                selector = spec6.getSelector();
            }
        } else if (entity instanceof StatefulSet) {
            StatefulSet resource7 = (StatefulSet)entity;
            StatefulSetSpec spec7 = resource7.getSpec();
            if (spec7 != null) {
                selector = spec7.getSelector();
            }
        } else if (entity instanceof Job && (spec = (resource = (Job)entity).getSpec()) != null) {
            selector = spec.getSelector();
        }
        return selector;
    }

    private static LabelSelector toLabelSelector(Map<String, String> matchLabels) {
        if (matchLabels != null && !matchLabels.isEmpty()) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(matchLabels)).build();
        }
        return null;
    }

    public static boolean isNewerResource(HasMetadata newer, HasMetadata older) {
        Date t1 = KubernetesHelper.getCreationTimestamp(newer);
        Date t2 = KubernetesHelper.getCreationTimestamp(older);
        return t1 != null && (t2 == null || t1.compareTo(t2) > 0);
    }

    public static Date getCreationTimestamp(HasMetadata hasMetadata) {
        ObjectMeta metadata = hasMetadata.getMetadata();
        if (metadata != null) {
            return KubernetesHelper.parseTimestamp(metadata.getCreationTimestamp());
        }
        return null;
    }

    private static Date parseTimestamp(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return KubernetesHelper.parseDate(text);
    }

    public static Date parseDate(String text) {
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Pod getNewestPod(Collection<Pod> pods) {
        if (pods == null || pods.isEmpty()) {
            return null;
        }
        ArrayList<Pod> sortedPods = new ArrayList<Pod>(pods);
        Collections.sort(sortedPods, (p1, p2) -> {
            Date t1 = KubernetesHelper.getCreationTimestamp((HasMetadata)p1);
            Date t2 = KubernetesHelper.getCreationTimestamp((HasMetadata)p2);
            if (t1 != null) {
                if (t2 == null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
            if (t2 == null) {
                return 0;
            }
            return -1;
        });
        return (Pod)sortedPods.get(sortedPods.size() - 1);
    }

    public static List<EnvVar> convertToEnvVarList(Map<String, String> envVars) {
        LinkedList<EnvVar> envList = new LinkedList<EnvVar>();
        for (Map.Entry entry : Optional.ofNullable(envVars).orElse(Collections.emptyMap()).entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name == null) continue;
            EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
            envList.add(env);
        }
        return envList;
    }

    public static boolean setEnvVar(List<EnvVar> envVarList, String name, String value) {
        for (EnvVar envVar : envVarList) {
            String envVarName = envVar.getName();
            if (!Objects.equals(name, envVarName)) continue;
            String oldValue = envVar.getValue();
            if (Objects.equals(value, oldValue)) {
                return false;
            }
            envVar.setValue(value);
            return true;
        }
        EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
        envVarList.add(env);
        return true;
    }

    public static String getEnvVar(List<EnvVar> envVarList, String name, String defaultValue) {
        String answer = defaultValue;
        if (envVarList != null) {
            for (EnvVar envVar : envVarList) {
                String value;
                String envVarName = envVar.getName();
                if (!Objects.equals(name, envVarName) || !StringUtils.isNotBlank((CharSequence)(value = envVar.getValue()))) continue;
                return value;
            }
        }
        return answer;
    }

    public static boolean removeEnvVar(List<EnvVar> envVarList, String name) {
        boolean removed = false;
        Iterator<EnvVar> it = envVarList.iterator();
        while (it.hasNext()) {
            EnvVar envVar = it.next();
            String envVarName = envVar.getName();
            if (!name.equals(envVarName)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public static File getResourceFragmentFromSource(File resourceDirFinal, List<String> remotes, String resourceNameSuffix, KitLogger log) {
        File[] resourceFiles = KubernetesHelper.listResourceFragments(resourceDirFinal, remotes, log);
        if (resourceFiles != null) {
            for (File file : resourceFiles) {
                if (!file.getName().endsWith(resourceNameSuffix)) continue;
                return file;
            }
        }
        return null;
    }

    public static Map<String, Quantity> getQuantityFromString(Map<String, String> quantity) {
        HashMap<String, Quantity> stringQuantityMap = new HashMap<String, Quantity>();
        if (quantity != null && !quantity.isEmpty()) {
            for (Map.Entry<String, String> entry : quantity.entrySet()) {
                stringQuantityMap.put(entry.getKey(), new Quantity(entry.getValue()));
            }
        }
        return stringQuantityMap;
    }

    public static File[] listResourceFragments(File localResourceDir, List<String> remotes, KitLogger log) {
        Object[] remoteResourceFiles;
        Object[] resourceFiles = KubernetesHelper.listResourceFragments(localResourceDir);
        if (remotes != null && (remoteResourceFiles = KubernetesHelper.listRemoteResourceFragments(remotes, log)).length > 0) {
            resourceFiles = (File[])ArrayUtils.addAll((Object[])resourceFiles, (Object[])remoteResourceFiles);
        }
        return resourceFiles;
    }

    public static File[] listResourceFragments(File resourceDir) {
        if (resourceDir == null) {
            return new File[0];
        }
        return resourceDir.listFiles((dir, name) -> FILENAME_PATTERN.matcher(name).matches() && !PROFILES_PATTERN.matcher(name).matches());
    }

    private static File[] listRemoteResourceFragments(List<String> remotes, KitLogger log) {
        if (!remotes.isEmpty()) {
            File remoteResources = FileUtil.createTempDirectory();
            FileUtil.downloadRemotes(remoteResources, remotes, log);
            if (remoteResources.isDirectory()) {
                return remoteResources.listFiles();
            }
        }
        return new File[0];
    }

    public static Map<String, Object> unmarshalCustomResourceFile(File customResourceFile) throws IOException {
        return (Map)Serialization.unmarshal((InputStream)new FileInputStream(customResourceFile), Map.class);
    }

    public static Map<File, String> getCustomResourcesFileToNameMap(File resourceDir, List<String> remotes, KitLogger log) throws IOException {
        File[] resourceFiles;
        HashMap<File, String> fileToCrdGroupMap = new HashMap<File, String>();
        for (File file : resourceFiles = KubernetesHelper.listResourceFragments(resourceDir, remotes, log)) {
            Map<String, Object> customResource;
            String apiVersion;
            if (!file.getName().endsWith("cr.yml") && !file.getName().endsWith("cr.yaml") || !(apiVersion = (customResource = KubernetesHelper.unmarshalCustomResourceFile(file)).get("apiVersion").toString()).contains("/")) continue;
            fileToCrdGroupMap.put(file, apiVersion.split("/")[0]);
        }
        return fileToCrdGroupMap;
    }
}

