/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringBootUtil.class);

    public static Properties getSpringBootApplicationProperties(URLClassLoader compileClassLoader) {
        return SpringBootUtil.getSpringBootApplicationProperties(null, compileClassLoader);
    }

    public static Properties getSpringBootApplicationProperties(String springActiveProfile, URLClassLoader compileClassLoader) {
        URL ymlResource = compileClassLoader.findResource("application.yml");
        URL propertiesResource = compileClassLoader.findResource("application.properties");
        Properties props = SpringBootUtil.getPropertiesFromApplicationYamlResource(springActiveProfile, ymlResource);
        props.putAll((Map<?, ?>)SpringBootUtil.getPropertiesResource(propertiesResource));
        return props;
    }

    public static Properties getPropertiesFromApplicationYamlResource(String springActiveProfile, URL ymlResource) {
        return YamlUtil.getPropertiesFromYamlResource(springActiveProfile, ymlResource);
    }

    protected static Properties getPropertiesResource(URL resource) {
        Properties answer = new Properties();
        if (resource != null) {
            try (InputStream stream = resource.openStream();){
                answer.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading resource from URL " + resource, e);
            }
        }
        return answer;
    }

    public static Optional<String> getSpringBootDevToolsVersion(JavaProject mavenProject) {
        return SpringBootUtil.getSpringBootVersion(mavenProject);
    }

    public static Optional<String> getSpringBootVersion(JavaProject mavenProject) {
        return Optional.ofNullable(JKubeProjectUtil.getAnyDependencyVersionWithGroupId(mavenProject, "org.springframework.boot"));
    }

    public static String getSpringBootActiveProfile(JavaProject project) {
        if (project != null && project.getProperties() != null && project.getProperties().get("spring.profiles.active") != null) {
            return project.getProperties().get("spring.profiles.active").toString();
        }
        return null;
    }
}

