/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;

public class YamlUtil {
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)YAML_FACTORY);
    private static final String EMPTY_YAML = "---\n";

    private YamlUtil() {
    }

    protected static Properties getPropertiesFromYamlResource(URL resource) {
        return YamlUtil.getPropertiesFromYamlResource(null, resource);
    }

    protected static Properties getPropertiesFromYamlResource(String activeProfile, URL resource) {
        if (resource != null) {
            try {
                Properties properties = new Properties();
                List<String> profiles = YamlUtil.splitYamlResource(resource);
                if (!profiles.isEmpty()) {
                    properties.putAll((Map<?, ?>)YamlUtil.getPropertiesFromYamlString(YamlUtil.getYamlFromYamlList(activeProfile, profiles)));
                }
                return properties;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading Yaml resource from URL " + resource, e);
            }
        }
        return new Properties();
    }

    private static Map<String, Object> getFlattenedMap(Map<?, ?> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        YamlUtil.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<?, ?> source, String path) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object value;
            String key;
            Object keyObject = entry.getKey();
            if (keyObject instanceof String) {
                key = (String)keyObject;
            } else if (keyObject instanceof Number) {
                key = String.valueOf(keyObject);
            } else {
                throw new IllegalArgumentException(String.format("Expected to find a key of type String but %s with content %s found.", keyObject.getClass(), keyObject.toString()));
            }
            if (path != null && path.trim().length() > 0) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof Map) {
                Map map = (Map)value;
                YamlUtil.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    YamlUtil.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }

    public static Properties getPropertiesFromYamlString(String yamlString) throws IOException {
        Properties properties = new Properties();
        SortedMap source = (SortedMap)YAML_MAPPER.readValue(Optional.ofNullable(yamlString).filter(StringUtils::isNotBlank).orElse(EMPTY_YAML), new TypeReference<SortedMap<String, ?>>(){});
        if (source != null) {
            properties.putAll(YamlUtil.getFlattenedMap(source));
        }
        return properties;
    }

    static List<String> splitYamlResource(URL resource) throws IOException {
        ArrayList<String> serializedYamlList = new ArrayList<String>();
        List parsedList = YAML_MAPPER.readValues((JsonParser)YAML_FACTORY.createParser(resource), new TypeReference<Map<String, ?>>(){}).readAll();
        for (Map listEntry : parsedList) {
            serializedYamlList.add(YAML_MAPPER.writeValueAsString((Object)listEntry));
        }
        return serializedYamlList;
    }

    static String getYamlFromYamlList(String pattern, List<String> yamlAsStringList) {
        if (pattern != null) {
            for (String yamlStr : yamlAsStringList) {
                if (!yamlStr.contains(pattern)) continue;
                return yamlStr;
            }
        }
        return yamlAsStringList.iterator().next();
    }
}

