/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NetworkConfig
implements Serializable {
    private final String name;
    private final Mode mode;
    private final List<String> aliases;

    public NetworkConfig() {
        this(null, null, null);
    }

    public NetworkConfig(Mode mode, String name, List<String> aliases) {
        this.name = name;
        this.mode = mode;
        this.aliases = Optional.ofNullable(aliases).orElse(new ArrayList());
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public static NetworkConfig fromLegacyNetSpec(String net) {
        Mode mode = null;
        String name = null;
        if (net != null) {
            mode = NetworkConfig.extractMode(net);
            if (mode == Mode.container) {
                name = net.substring(Mode.container.name().length() + 1);
            } else if (mode == Mode.custom) {
                name = net;
            }
        }
        return NetworkConfig.builder().mode(mode).name(name).build();
    }

    private static Mode extractMode(String mode) {
        if (mode != null && mode.length() > 0) {
            try {
                return Mode.valueOf(mode.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (mode.toLowerCase().startsWith(Mode.container.name() + ":")) {
                    return Mode.container;
                }
                return Mode.custom;
            }
        }
        return null;
    }

    public boolean isCustomNetwork() {
        return this.mode != null && this.mode == Mode.custom || this.mode == null && this.name != null;
    }

    public boolean isStandardNetwork() {
        return this.mode != null && this.mode != Mode.custom;
    }

    public String getStandardMode(String containerId) {
        if (this.isCustomNetwork()) {
            throw new IllegalArgumentException("Custom network for network '" + this.name + "' can not be used as standard mode");
        }
        if (this.mode == null) {
            return null;
        }
        return this.mode.name().toLowerCase() + (this.mode == Mode.container ? ":" + containerId : "");
    }

    public String getContainerAlias() {
        return this.mode == Mode.container ? this.name : null;
    }

    public String getCustomNetwork() {
        return this.mode == Mode.custom || this.mode == null ? this.name : null;
    }

    public boolean hasAliases() {
        return this.aliases != null && !this.aliases.isEmpty();
    }

    public static NetworkConfigBuilder builder() {
        return new NetworkConfigBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkConfig)) {
            return false;
        }
        NetworkConfig other = (NetworkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        List<String> this$aliases = this.getAliases();
        List<String> other$aliases = other.getAliases();
        return !(this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetworkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        List<String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        return result;
    }

    public static class NetworkConfigBuilder {
        private Mode mode;
        private String name;
        private List<String> aliases;

        public NetworkConfigBuilder modeString(String modeString) {
            this.mode = Optional.ofNullable(modeString).map(Mode::valueOf).orElse(null);
            return this;
        }

        public NetworkConfig build() {
            return this.mode == null && this.name == null && this.aliases == null ? null : new NetworkConfig(this.mode, this.name, this.aliases);
        }

        NetworkConfigBuilder() {
        }

        public NetworkConfigBuilder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public NetworkConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NetworkConfigBuilder aliases(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public String toString() {
            return "NetworkConfig.NetworkConfigBuilder(mode=" + (Object)((Object)this.mode) + ", name=" + this.name + ", aliases=" + this.aliases + ")";
        }
    }

    public static enum Mode {
        none,
        bridge,
        host,
        container,
        custom;

    }
}

