/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OpenshiftBuildConfig {
    private Map<String, String> limits;
    private Map<String, String> requests;

    public static OpenshiftBuildConfigBuilder builder() {
        return new OpenshiftBuildConfigBuilder();
    }

    public OpenshiftBuildConfigBuilder toBuilder() {
        OpenshiftBuildConfigBuilder builder = new OpenshiftBuildConfigBuilder();
        if (this.limits != null) {
            builder.limits(this.limits);
        }
        if (this.requests != null) {
            builder.requests(this.requests);
        }
        return builder;
    }

    public OpenshiftBuildConfig(Map<String, String> limits, Map<String, String> requests) {
        this.limits = limits;
        this.requests = requests;
    }

    public OpenshiftBuildConfig() {
    }

    public Map<String, String> getLimits() {
        return this.limits;
    }

    public Map<String, String> getRequests() {
        return this.requests;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenshiftBuildConfig)) {
            return false;
        }
        OpenshiftBuildConfig other = (OpenshiftBuildConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$limits = this.getLimits();
        Map<String, String> other$limits = other.getLimits();
        if (this$limits == null ? other$limits != null : !((Object)this$limits).equals(other$limits)) {
            return false;
        }
        Map<String, String> this$requests = this.getRequests();
        Map<String, String> other$requests = other.getRequests();
        return !(this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenshiftBuildConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $limits = this.getLimits();
        result = result * 59 + ($limits == null ? 43 : ((Object)$limits).hashCode());
        Map<String, String> $requests = this.getRequests();
        result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
        return result;
    }

    public static class OpenshiftBuildConfigBuilder {
        private ArrayList<String> limits$key;
        private ArrayList<String> limits$value;
        private ArrayList<String> requests$key;
        private ArrayList<String> requests$value;

        OpenshiftBuildConfigBuilder() {
        }

        public OpenshiftBuildConfigBuilder limit(String limitKey, String limitValue) {
            if (this.limits$key == null) {
                this.limits$key = new ArrayList();
                this.limits$value = new ArrayList();
            }
            this.limits$key.add(limitKey);
            this.limits$value.add(limitValue);
            return this;
        }

        public OpenshiftBuildConfigBuilder limits(Map<? extends String, ? extends String> limits) {
            if (limits == null) {
                throw new NullPointerException("limits cannot be null");
            }
            if (this.limits$key == null) {
                this.limits$key = new ArrayList();
                this.limits$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : limits.entrySet()) {
                this.limits$key.add($lombokEntry.getKey());
                this.limits$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OpenshiftBuildConfigBuilder clearLimits() {
            if (this.limits$key != null) {
                this.limits$key.clear();
                this.limits$value.clear();
            }
            return this;
        }

        public OpenshiftBuildConfigBuilder request(String requestKey, String requestValue) {
            if (this.requests$key == null) {
                this.requests$key = new ArrayList();
                this.requests$value = new ArrayList();
            }
            this.requests$key.add(requestKey);
            this.requests$value.add(requestValue);
            return this;
        }

        public OpenshiftBuildConfigBuilder requests(Map<? extends String, ? extends String> requests) {
            if (requests == null) {
                throw new NullPointerException("requests cannot be null");
            }
            if (this.requests$key == null) {
                this.requests$key = new ArrayList();
                this.requests$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : requests.entrySet()) {
                this.requests$key.add($lombokEntry.getKey());
                this.requests$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public OpenshiftBuildConfigBuilder clearRequests() {
            if (this.requests$key != null) {
                this.requests$key.clear();
                this.requests$value.clear();
            }
            return this;
        }

        public OpenshiftBuildConfig build() {
            Map<String, String> requests;
            Map<String, String> limits;
            switch (this.limits$key == null ? 0 : this.limits$key.size()) {
                case 0: {
                    limits = Collections.emptyMap();
                    break;
                }
                case 1: {
                    limits = Collections.singletonMap(this.limits$key.get(0), this.limits$value.get(0));
                    break;
                }
                default: {
                    limits = new LinkedHashMap(this.limits$key.size() < 0x40000000 ? 1 + this.limits$key.size() + (this.limits$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.limits$key.size(); ++$i) {
                        limits.put(this.limits$key.get($i), this.limits$value.get($i));
                    }
                    limits = Collections.unmodifiableMap(limits);
                }
            }
            switch (this.requests$key == null ? 0 : this.requests$key.size()) {
                case 0: {
                    requests = Collections.emptyMap();
                    break;
                }
                case 1: {
                    requests = Collections.singletonMap(this.requests$key.get(0), this.requests$value.get(0));
                    break;
                }
                default: {
                    requests = new LinkedHashMap<String, String>(this.requests$key.size() < 0x40000000 ? 1 + this.requests$key.size() + (this.requests$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.requests$key.size(); ++$i) {
                        requests.put(this.requests$key.get($i), this.requests$value.get($i));
                    }
                    requests = Collections.unmodifiableMap(requests);
                }
            }
            return new OpenshiftBuildConfig(limits, requests);
        }

        public String toString() {
            return "OpenshiftBuildConfig.OpenshiftBuildConfigBuilder(limits$key=" + this.limits$key + ", limits$value=" + this.limits$value + ", requests$key=" + this.requests$key + ", requests$value=" + this.requests$value + ")";
        }
    }
}

