/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.openshift.api.model.Project;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.UndeployService;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class KubernetesUndeployService
implements UndeployService {
    private final JKubeServiceHub jKubeServiceHub;
    private final KitLogger logger;

    public KubernetesUndeployService(JKubeServiceHub jKubeServiceHub, KitLogger logger) {
        this.jKubeServiceHub = jKubeServiceHub;
        this.logger = logger;
    }

    @Override
    public void undeploy(File resourceDir, ResourceConfig resourceConfig, File ... manifestFiles) throws IOException {
        List manifests = Stream.of(manifestFiles).filter(Objects::nonNull).filter(File::exists).filter(File::isFile).collect(Collectors.toList());
        ArrayList<HasMetadata> entities = new ArrayList<HasMetadata>();
        for (File manifest : manifests) {
            entities.addAll(KubernetesHelper.loadResources((File)manifest));
        }
        if (entities.isEmpty()) {
            this.logger.warn("No such generated manifests found for this project, ignoring.", new Object[0]);
            return;
        }
        Collections.reverse(entities);
        String currentNamespace = this.currentNamespace(entities);
        this.undeployResources(currentNamespace, entities);
        this.undeployCustomResources(currentNamespace, resourceDir, resourceConfig);
    }

    private void undeployResources(String namespace, List<HasMetadata> entities) {
        Consumer<HasMetadata> resourceDeleter = this.resourceDeleter(namespace);
        entities.stream().filter(e -> !(e instanceof Namespace)).filter(e -> !(e instanceof Project)).forEach(resourceDeleter);
    }

    protected Consumer<HasMetadata> resourceDeleter(String namespace) {
        return resource -> {
            this.logger.info("Deleting resource %s %s/%s", new Object[]{KubernetesHelper.getKind((HasMetadata)resource), namespace, KubernetesHelper.getName((HasMetadata)resource)});
            ((CascadingDeletable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.jKubeServiceHub.getClient().resource(resource).inNamespace(namespace)).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        };
    }

    private void undeployCustomResources(String namespace, File resourceDir, ResourceConfig resourceConfig) throws IOException {
        if (resourceConfig == null || resourceConfig.getCustomResourceDefinitions() == null || resourceConfig.getCustomResourceDefinitions().isEmpty()) {
            return;
        }
        List<CustomResourceDefinitionContext> crdContexts = KubernetesClientUtil.getCustomResourceDefinitionContext(this.jKubeServiceHub.getClient(), resourceConfig.getCustomResourceDefinitions());
        Map fileToCrdMap = KubernetesHelper.getCustomResourcesFileToNameMap((File)resourceDir, (List)resourceConfig.getRemotes(), (KitLogger)this.logger);
        for (CustomResourceDefinitionContext customResourceDefinitionContext : crdContexts) {
            for (Map.Entry entry : fileToCrdMap.entrySet()) {
                if (!((String)entry.getValue()).equals(customResourceDefinitionContext.getGroup())) continue;
                this.deleteCustomResource((File)entry.getKey(), namespace, customResourceDefinitionContext);
            }
        }
    }

    String currentNamespace(List<HasMetadata> entities) {
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Namespace) && !(entity instanceof Project)) continue;
            return entity.getMetadata().getName();
        }
        return this.jKubeServiceHub.getClusterAccess().getNamespace();
    }

    private void deleteCustomResource(File customResourceFile, String namespace, CustomResourceDefinitionContext crdContext) throws IOException {
        Map customResource = KubernetesHelper.unmarshalCustomResourceFile((File)customResourceFile);
        Map objectMeta = (Map)customResource.get("metadata");
        String name = objectMeta.get("name").toString();
        this.logger.info("Deleting Custom Resource %s", new Object[]{name});
        KubernetesClientUtil.doDeleteCustomResource(this.jKubeServiceHub.getClient(), crdContext, namespace, name);
    }

    protected JKubeServiceHub getjKubeServiceHub() {
        return this.jKubeServiceHub;
    }

    protected KitLogger getLogger() {
        return this.logger;
    }
}

