/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import io.fabric8.kubernetes.api.model.batch.JobSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class JobHandler {
    private final PodTemplateHandler podTemplateHandler;

    JobHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public Job getJob(ResourceConfig config, List<ImageConfiguration> images) {
        return ((JobBuilder)((JobBuilder)new JobBuilder().withMetadata(this.createJobSpecMetaData(config))).withSpec(this.createJobSpec(config, images))).build();
    }

    private ObjectMeta createJobSpecMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private JobSpec createJobSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((JobSpecBuilder)new JobSpecBuilder().withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

