/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class ImageEnricher
extends BaseEnricher {
    public ImageEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-image");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (!this.hasImageConfiguration()) {
            this.log.verbose("No images resolved. Skipping ...", new Object[0]);
            return;
        }
        this.ensureTemplateSpecs(builder);
        this.updateContainers(builder);
    }

    private void ensureTemplateSpecs(KubernetesListBuilder builder) {
        this.ensureTemplateSpecsInReplicationControllers(builder);
        this.ensureTemplateSpecsInRelicaSet(builder);
        this.ensureTemplateSpecsInDeployments(builder);
        this.ensureTemplateSpecsInDaemonSet(builder);
        this.ensureTemplateSpecsInStatefulSet(builder);
        this.ensureTemplateSpecsInDeploymentConfig(builder);
    }

    private void ensureTemplateSpecsInReplicationControllers(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder item) {
                ReplicationControllerFluent.SpecNested spec = item.buildSpec() == null ? item.withNewSpec() : item.editSpec();
                ReplicationControllerSpecFluent.TemplateNested template = spec.buildTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((ReplicationControllerFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInRelicaSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder item) {
                ReplicaSetFluent.SpecNested spec = item.buildSpec() == null ? item.withNewSpec() : item.editSpec();
                ReplicaSetSpecFluent.TemplateNested template = spec.buildTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((ReplicaSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDeployments(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder item) {
                DeploymentFluent.SpecNested spec = item.buildSpec() == null ? item.withNewSpec() : item.editSpec();
                DeploymentSpecFluent.TemplateNested template = spec.buildTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DeploymentFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDaemonSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder item) {
                DaemonSetFluent.SpecNested spec = item.buildSpec() == null ? item.withNewSpec() : item.editSpec();
                DaemonSetSpecFluent.TemplateNested template = spec.buildTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DaemonSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInStatefulSet(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder item) {
                StatefulSetFluent.SpecNested spec = item.buildSpec() == null ? item.withNewSpec() : item.editSpec();
                StatefulSetSpecFluent.TemplateNested template = spec.buildTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((StatefulSetFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void ensureTemplateSpecsInDeploymentConfig(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder item) {
                DeploymentConfigFluent.SpecNested spec = item.buildSpec() == null ? item.withNewSpec() : item.editSpec();
                DeploymentConfigSpecFluent.TemplateNested template = spec.buildTemplate() == null ? spec.withNewTemplate() : spec.editTemplate();
                ((DeploymentConfigFluent.SpecNested)template.endTemplate()).endSpec();
            }
        });
    }

    private void updateContainers(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder templateBuilder) {
                PodTemplateSpecFluent.SpecNested podSpec = templateBuilder.buildSpec() == null ? templateBuilder.withNewSpec() : templateBuilder.editSpec();
                ArrayList containers = podSpec.buildContainers();
                if (containers == null) {
                    containers = new ArrayList();
                }
                ImageEnricher.this.mergeImageConfigurationWithContainerSpec(containers);
                ((PodTemplateSpecFluent.SpecNested)podSpec.withContainers(containers)).endSpec();
            }
        });
    }

    private void mergeImageConfigurationWithContainerSpec(List<Container> containers) {
        int idx = 0;
        for (ImageConfiguration image : this.getImages()) {
            Container container = this.getContainer(idx, containers);
            this.mergeImagePullPolicy(image, container);
            this.mergeImage(image, container);
            this.mergeContainerName(image, container);
            this.mergeEnvVariables(container);
            ++idx;
        }
    }

    private Container getContainer(int idx, List<Container> containers) {
        Container container;
        if (idx < containers.size()) {
            container = containers.get(idx);
        } else {
            container = new Container();
            containers.add(container);
        }
        return container;
    }

    private void mergeContainerName(ImageConfiguration imageConfiguration, Container container) {
        if (StringUtils.isBlank((CharSequence)container.getName())) {
            String containerName = KubernetesResourceUtil.extractContainerName((GroupArtifactVersion)this.getContext().getGav(), (ImageConfiguration)imageConfiguration);
            this.log.verbose("Setting container name %s", new Object[]{containerName});
            container.setName(containerName);
        }
    }

    private void mergeImage(ImageConfiguration imageConfiguration, Container container) {
        if (StringUtils.isBlank((CharSequence)container.getImage())) {
            String prefix = "";
            if (StringUtils.isNotBlank((CharSequence)imageConfiguration.getRegistry())) {
                this.log.verbose("Using registry %s for the image", new Object[]{imageConfiguration.getRegistry()});
                prefix = imageConfiguration.getRegistry() + "/";
            }
            String imageFullName = prefix + imageConfiguration.getName();
            this.log.verbose("Setting image %s", new Object[]{imageFullName});
            container.setImage(imageFullName);
        }
    }

    private void mergeImagePullPolicy(ImageConfiguration imageConfiguration, Container container) {
        if (StringUtils.isBlank((CharSequence)container.getImagePullPolicy())) {
            String policy = this.getConfig(Config.PULL_POLICY);
            if (policy == null) {
                policy = "IfNotPresent";
                String imageName = imageConfiguration.getName();
                if (StringUtils.isNotBlank((CharSequence)imageName) && imageName.endsWith(":latest")) {
                    policy = "Always";
                }
            }
            container.setImagePullPolicy(policy);
        }
    }

    private void mergeEnvVariables(Container container) {
        Optional.ofNullable(this.getConfiguration().getResource()).map(ResourceConfig::getEnv).ifPresent(resourceEnv -> {
            LinkedList<EnvVar> containerEnvVars = container.getEnv();
            if (containerEnvVars == null) {
                containerEnvVars = new LinkedList<EnvVar>();
                container.setEnv(containerEnvVars);
            }
            for (Map.Entry resourceEnvEntry : resourceEnv.entrySet()) {
                EnvVar newEnvVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)resourceEnvEntry.getKey())).withValue((String)resourceEnvEntry.getValue())).build();
                if (!this.hasEnvWithName(containerEnvVars, newEnvVar.getName())) {
                    containerEnvVars.add(newEnvVar);
                    continue;
                }
                this.log.warn("Environment variable %s will not be overridden: trying to set the value %s, but its actual value is %s", new Object[]{newEnvVar.getName(), newEnvVar.getValue(), this.getEnvValue(containerEnvVars, newEnvVar.getName())});
            }
        });
    }

    private String getEnvValue(List<EnvVar> envVars, String name) {
        for (EnvVar var : envVars) {
            if (!var.getName().equals(name)) continue;
            return var.getValue();
        }
        return "(not found)";
    }

    private boolean hasEnvWithName(List<EnvVar> envVars, String name) {
        return envVars.stream().anyMatch(e -> e.getName().equals(name));
    }

    private static enum Config implements Configs.Config
    {
        PULL_POLICY("pullPolicy");

        protected String key;

        private Config(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

