/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class RouteEnricher
extends BaseEnricher {
    private static final String GENERATE_ROUTE_PROPERTY = "jkube.openshift.generateRoute";
    public static final String EXPOSE_LABEL = "expose";
    private String routeDomainPostfix;

    public RouteEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-openshift-route");
    }

    private boolean isGenerateRoute() {
        return Configs.asBoolean((String)this.getConfigWithFallback(Config.GENERATE_ROUTE, GENERATE_ROUTE_PROPERTY, null));
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        ResourceConfig resourceConfig = this.getConfiguration().getResource();
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            this.routeDomainPostfix = resourceConfig.getRouteDomain();
        }
        if (platformMode == PlatformMode.openshift && this.isGenerateRoute()) {
            final ArrayList routes = new ArrayList();
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    RouteEnricher.this.addRoute(listBuilder, serviceBuilder, routes);
                }
            });
            if (!routes.isEmpty()) {
                Route[] routeArray = new Route[routes.size()];
                routes.toArray(routeArray);
                listBuilder.addToItems((HasMetadata[])routeArray);
            }
        }
    }

    private RoutePort createRoutePort(ServiceBuilder serviceBuilder) {
        IntOrString targetPort;
        ServicePort servicePort;
        List ports;
        RoutePort routePort = null;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null && !ports.isEmpty() && (servicePort = (ServicePort)ports.get(0)) != null && (targetPort = servicePort.getTargetPort()) != null) {
            routePort = new RoutePort();
            routePort.setTargetPort(targetPort);
        }
        return routePort;
    }

    private String prepareHostForRoute(String routeDomainPostfix, String name) {
        String ret = FileUtil.stripPostfix((String)name, (String)"-service");
        ret = FileUtil.stripPostfix((String)ret, (String)".");
        ret = ret + ".";
        ret = ret + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
        return ret;
    }

    private Set<Integer> getPorts(ServiceBuilder service) {
        HashSet<Integer> answer = new HashSet<Integer>();
        if (service != null) {
            ServiceSpec spec = RouteEnricher.getOrCreateSpec(service);
            for (ServicePort port : spec.getPorts()) {
                answer.add(port.getPort());
            }
        }
        return answer;
    }

    public static ServiceSpec getOrCreateSpec(ServiceBuilder entity) {
        ServiceSpec spec = entity.buildSpec();
        if (spec == null) {
            spec = new ServiceSpec();
            entity.editOrNewSpec().endSpec();
        }
        return spec;
    }

    private boolean hasExactlyOneServicePort(ServiceBuilder service, String id) {
        Set<Integer> ports = this.getPorts(service);
        if (ports.size() != 1) {
            this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
            return false;
        }
        return true;
    }

    private void addRoute(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder, List<Route> routes) {
        String name;
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata != null && StringUtils.isNotBlank((CharSequence)serviceMetadata.getName()) && this.hasExactlyOneServicePort(serviceBuilder, serviceMetadata.getName()) && RouteEnricher.isExposedService(serviceMetadata) && !this.hasRoute(listBuilder, name = serviceMetadata.getName())) {
            this.routeDomainPostfix = StringUtils.isNotBlank((CharSequence)this.routeDomainPostfix) ? this.prepareHostForRoute(this.routeDomainPostfix, name) : "";
            RoutePort routePort = this.createRoutePort(serviceBuilder);
            if (routePort != null) {
                RouteBuilder routeBuilder = (RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteBuilder)new RouteBuilder().withMetadata(serviceMetadata)).withNewSpec().withPort(routePort)).withNewTo().withKind("Service")).withName(name)).endTo()).withHost(this.routeDomainPostfix.isEmpty() ? null : this.routeDomainPostfix)).endSpec();
                KubernetesResourceUtil.removeLabel((ObjectMeta)routeBuilder.buildMetadata(), (String)EXPOSE_LABEL, (String)"true");
                KubernetesResourceUtil.removeLabel((ObjectMeta)routeBuilder.buildMetadata(), (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value(), (String)"true");
                routeBuilder.withNewMetadataLike(routeBuilder.buildMetadata());
                routes.add(routeBuilder.build());
            }
        }
    }

    private boolean hasRoute(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept((Visitor)new TypedVisitor<RouteBuilder>(){

            public void visit(RouteBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        });
        return answer.get();
    }

    private static boolean isExposedService(ObjectMeta objectMeta) {
        return KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)objectMeta, (String)EXPOSE_LABEL, (String)"true") || KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)objectMeta, (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value(), (String)"true");
    }

    private static enum Config implements Configs.Config
    {
        GENERATE_ROUTE("generateRoute", "true");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

