/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.valuegens;

import java.lang.reflect.Array;
import org.apache.commons.lang3.Validate;
import org.force66.beantester.valuegens.ValueGenerator;
import org.force66.beantester.valuegens.ValueGeneratorFactory;

public class ArrayValueGenerator
implements ValueGenerator<Object> {
    private Class<?> arrayType;
    private ValueGeneratorFactory valueGeneratorFactory;

    public ArrayValueGenerator(Class<?> type, ValueGeneratorFactory valueGeneratorFactory) {
        Validate.notNull(type, (String)"Null array type not allowed", (Object[])new Object[0]);
        Validate.notNull((Object)valueGeneratorFactory, (String)"Null valueGeneratorFactory not allowed", (Object[])new Object[0]);
        Validate.isTrue((boolean)type.isArray(), (String)"Provided class must be an array.  class=%s", (Object[])new Object[]{type.getName()});
        this.arrayType = type;
        this.valueGeneratorFactory = valueGeneratorFactory;
    }

    @Override
    public Object[] makeValues() {
        Object[] objArray = new Object[]{Array.newInstance(this.arrayType.getComponentType(), 1)};
        ValueGenerator<?> gen = this.valueGeneratorFactory.forClass(this.arrayType.getComponentType());
        Array.set(objArray[0], 0, gen.makeValues()[0]);
        return objArray;
    }

    @Override
    public boolean canGenerate(Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        return targetClass.isArray();
    }
}

