/*
 * Decompiled with CFR 0.152.
 */
package org.force66.beantester.valuegens;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.Validate;
import org.force66.beantester.utils.BeanTesterException;
import org.force66.beantester.valuegens.ValueGenerator;

public class TemporalValueGenerator
implements ValueGenerator<Object> {
    private Class<?> temporalType;
    private Constructor<?> longConstructor;

    public TemporalValueGenerator(Class<?> type) {
        Constructor<?>[] allConstructors;
        this.temporalType = type;
        for (Constructor<?> ctor : allConstructors = type.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length != 1 || !ctor.getParameterTypes()[0].getName().equals("long")) continue;
            this.longConstructor = ctor;
        }
        Validate.notNull(this.longConstructor, (String)("Not a temporal object with a long constructor.   class=" + type.getName()), (Object[])new Object[0]);
    }

    @Override
    public Object[] makeValues() {
        Object obj = null;
        try {
            obj = this.longConstructor.newInstance(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new BeanTesterException("Error instantiating temporal object with long constructor").addContextValue("class", this.temporalType.getName());
        }
        return new Object[]{obj};
    }

    @Override
    public boolean canGenerate(Class<?> targetClass) {
        return this.temporalType.equals(targetClass);
    }
}

