/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.component;

import com.sun.faces.ext.component.WholeBeanValidator;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.validation.groups.Default;

public class UIValidateWholeBean
extends UIInput
implements PartialStateHolder {
    private static final String ERROR_MISSING_FORM = "f:validateWholeBean must be nested directly in an UIForm.";
    private static final String ERROR_MISPLACED_COMPONENT = "f:validateWholeBean must be placed at the end of UIForm.";
    public static final String FAMILY = "com.sun.faces.ext.validateWholeBean";
    private transient Class<?>[] cachedValidationGroups;
    private transient String validationGroups = "";
    private boolean transientValue;
    private boolean initialState;

    @Override
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public Object getSubmittedValue() {
        return this.getFamily();
    }

    @Override
    public void setConverter(Converter converter) {
    }

    @Override
    public final void addValidator(Validator validator) {
        if (validator instanceof WholeBeanValidator) {
            super.addValidator(validator);
            this.setValidatorInstalled(true);
        }
    }

    public void setValidationGroups(String validationGroups) {
        this.clearInitialState();
        String newValidationGroups = validationGroups;
        if (newValidationGroups != null && newValidationGroups.matches("^[\\W,]*$")) {
            newValidationGroups = null;
        }
        if (newValidationGroups == null && validationGroups != null) {
            this.cachedValidationGroups = null;
        }
        if (newValidationGroups != null && validationGroups != null && !newValidationGroups.equals(validationGroups)) {
            this.cachedValidationGroups = null;
        }
        if (newValidationGroups != null && validationGroups == null) {
            this.cachedValidationGroups = null;
        }
        this.validationGroups = newValidationGroups;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    @Override
    public void validate(FacesContext context) {
        if (!this.wholeBeanValidationEnabled(context)) {
            return;
        }
        if (!this.isValidatorInstalled()) {
            WholeBeanValidator validator = new WholeBeanValidator();
            this.addValidator(validator);
        }
        super.validate(context);
    }

    @Override
    public void updateModel(FacesContext context) {
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        UIForm parent = UIValidateWholeBean.getClosestParent(this, UIForm.class);
        if (parent == null) {
            throw new IllegalArgumentException(ERROR_MISSING_FORM);
        }
        UIValidateWholeBean.misplacedComponentCheck(parent, this.getClientId());
    }

    private static void misplacedComponentCheck(UIComponent parentComponent, String clientId) throws IllegalArgumentException {
        try {
            Util.reverse(parentComponent.getChildren()).stream().forEach(childComponent -> {
                if (childComponent.isRendered()) {
                    if (childComponent instanceof EditableValueHolder && !(childComponent instanceof UIValidateWholeBean)) {
                        throw new IllegalArgumentException(ERROR_MISPLACED_COMPONENT);
                    }
                    if (!childComponent.getClientId().equals(clientId)) {
                        UIValidateWholeBean.misplacedComponentCheck(childComponent, clientId);
                    } else {
                        throw new BreakException();
                    }
                }
            });
        }
        catch (BreakException breakException) {
            // empty catch block
        }
    }

    public static <C extends UIComponent> C getClosestParent(UIComponent component, Class<C> parentType) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !parentType.isInstance(parent); parent = parent.getParent()) {
        }
        return (C)((UIComponent)parentType.cast(parent));
    }

    private boolean isValidatorInstalled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.ValidatorInstalled), false);
    }

    private void setValidatorInstalled(boolean newValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.ValidatorInstalled), newValue);
    }

    Class<?>[] getValidationGroupsArray() {
        if (this.cachedValidationGroups != null) {
            return this.cachedValidationGroups;
        }
        String validationGroupsStr = this.getValidationGroups();
        ArrayList validationGroupsList = new ArrayList();
        for (String className : validationGroupsStr.split(",")) {
            if ((className = className.trim()).length() == 0) continue;
            if (className.equals(Default.class.getName())) {
                validationGroupsList.add(Default.class);
                continue;
            }
            validationGroupsList.add(this.classForName(className));
        }
        this.cachedValidationGroups = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        return this.cachedValidationGroups;
    }

    private boolean wholeBeanValidationEnabled(FacesContext context) {
        return Boolean.TRUE.equals(context.getAttributes().get("javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN"));
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    @Override
    public boolean isTransient() {
        return this.transientValue;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.validationGroups, super.saveState(context)};
            return values;
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.validationGroups = (String)values[0];
            Object parentState = values[1];
            super.restoreState(context, parentState);
        }
    }

    private Class<?> classForName(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e1) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new FacesException("Validation group not found: " + className);
            }
        }
    }

    private static class BreakException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private BreakException() {
        }
    }

    private static enum PropertyKeys {
        ValidatorInstalled;

    }
}

