/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.JsonPrettyGeneratorImpl;
import org.glassfish.json.api.BufferPool;

class JsonWriterImpl
implements JsonWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final JsonGeneratorImpl generator;
    private boolean writeDone;

    JsonWriterImpl(Writer writer, BufferPool bufferPool) {
        this(writer, false, bufferPool);
    }

    JsonWriterImpl(Writer writer, boolean prettyPrinting, BufferPool bufferPool) {
        this.generator = prettyPrinting ? new JsonPrettyGeneratorImpl(writer, bufferPool) : new JsonGeneratorImpl(writer, bufferPool);
    }

    JsonWriterImpl(OutputStream out, BufferPool bufferPool) {
        this(out, UTF_8, false, bufferPool);
    }

    JsonWriterImpl(OutputStream out, boolean prettyPrinting, BufferPool bufferPool) {
        this(out, UTF_8, prettyPrinting, bufferPool);
    }

    JsonWriterImpl(OutputStream out, Charset charset, boolean prettyPrinting, BufferPool bufferPool) {
        this.generator = prettyPrinting ? new JsonPrettyGeneratorImpl(out, charset, bufferPool) : new JsonGeneratorImpl(out, charset, bufferPool);
    }

    @Override
    public void writeArray(JsonArray array) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        this.generator.writeStartArray();
        for (JsonValue value : array) {
            this.generator.write(value);
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
    }

    @Override
    public void writeObject(JsonObject object) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        this.generator.writeStartObject();
        for (Map.Entry e : object.entrySet()) {
            this.generator.write((String)e.getKey(), (JsonValue)e.getValue());
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
    }

    @Override
    public void write(JsonStructure value) {
        if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else {
            this.writeObject((JsonObject)value);
        }
    }

    @Override
    public void close() {
        this.writeDone = true;
        this.generator.close();
    }
}

