/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.common.util.XMLUtil;
import com.sun.xml.registry.uddi.JAXRConstants;
import com.sun.xml.registry.uddi.bindings_v2_2.URLType;
import com.sun.xml.registry.uddi.infomodel.OrganizationImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class MapperHelpers
extends JAXRConstants {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    private static XMLUtil xmlUtil;
    private static MarshallerUtil marshallerUtil;

    MapperHelpers() {
    }

    Collection getCallerIsTargetByState(Collection associations, Boolean callerConfirmed, Boolean otherConfirmed) throws JAXRException {
        boolean callerIsConfirmed;
        ArrayList<Association> matchingTargetAssociations = new ArrayList<Association>();
        if (callerConfirmed != null && otherConfirmed != null) {
            callerIsConfirmed = callerConfirmed;
            boolean otherIsConfirmed = otherConfirmed;
            for (Association association : associations) {
                boolean sourceObjectConfirmed = association.isConfirmedBySourceOwner();
                boolean targetObjectConfirmed = association.isConfirmedByTargetOwner();
                if (targetObjectConfirmed != callerIsConfirmed || sourceObjectConfirmed != otherIsConfirmed) continue;
                matchingTargetAssociations.add(association);
            }
        }
        if (callerConfirmed != null && otherConfirmed == null) {
            callerIsConfirmed = callerConfirmed;
            for (Association association : associations) {
                boolean targetObjectConfirmed = association.isConfirmedByTargetOwner();
                if (targetObjectConfirmed != callerIsConfirmed) continue;
                matchingTargetAssociations.add(association);
            }
        }
        if (callerConfirmed == null && otherConfirmed != null) {
            boolean otherIsConfirmed = otherConfirmed;
            for (Association association : associations) {
                boolean sourceObjectConfirmed = association.isConfirmedBySourceOwner();
                if (sourceObjectConfirmed != otherIsConfirmed) continue;
                matchingTargetAssociations.add(association);
            }
        }
        if (callerConfirmed == null && otherConfirmed == null) {
            matchingTargetAssociations.addAll(associations);
        }
        return matchingTargetAssociations;
    }

    Collection getCallerIsSourceByState(Collection associations, Boolean callerConfirmed, Boolean otherConfirmed) throws JAXRException {
        boolean callerIsConfirmed;
        ArrayList<Association> matchingSourceAssociations = new ArrayList<Association>();
        if (callerConfirmed != null && otherConfirmed != null) {
            callerIsConfirmed = callerConfirmed;
            boolean otherIsConfirmed = otherConfirmed;
            for (Association association : associations) {
                boolean sourceObjectConfirmed = association.isConfirmedBySourceOwner();
                boolean targetObjectConfirmed = association.isConfirmedByTargetOwner();
                if (sourceObjectConfirmed != callerIsConfirmed || targetObjectConfirmed != otherIsConfirmed) continue;
                matchingSourceAssociations.add(association);
            }
        }
        if (callerConfirmed != null && otherConfirmed == null) {
            callerIsConfirmed = callerConfirmed;
            for (Association association : associations) {
                boolean sourceObjectConfirmed = association.isConfirmedBySourceOwner();
                if (sourceObjectConfirmed != callerIsConfirmed) continue;
                matchingSourceAssociations.add(association);
            }
        }
        if (callerConfirmed == null && otherConfirmed != null) {
            boolean otherIsConfirmed = otherConfirmed;
            for (Association association : associations) {
                boolean targetObjectConfirmed = association.isConfirmedByTargetOwner();
                if (targetObjectConfirmed != otherIsConfirmed) continue;
                matchingSourceAssociations.add(association);
            }
        }
        if (callerConfirmed == null && otherConfirmed == null) {
            matchingSourceAssociations.addAll(associations);
        }
        return matchingSourceAssociations;
    }

    Collection getCallerTargetAssociations(Collection associations, Collection callerToKeys) throws JAXRException {
        ArrayList<Association> callerTargetAssociations = new ArrayList<Association>();
        for (Association association : associations) {
            RegistryObject targetObject = association.getTargetObject();
            if (targetObject == null) continue;
            String targetId = targetObject.getKey().getId();
            for (String toKey : callerToKeys) {
                if (!toKey.equalsIgnoreCase(targetId)) continue;
                callerTargetAssociations.add(association);
            }
        }
        return callerTargetAssociations;
    }

    Collection getCallerSourceAssociations(Collection associations, Collection callerFromKeys, Collection fromKeysOwned, Collection toKeysOwned) throws JAXRException {
        ArrayList<Association> callerSourceAssociations = new ArrayList<Association>();
        for (Association association : associations) {
            RegistryObject sourceObject = association.getSourceObject();
            if (sourceObject == null) continue;
            String sourceId = sourceObject.getKey().getId();
            for (String fromKey : callerFromKeys) {
                if (!fromKey.equalsIgnoreCase(sourceId)) continue;
                callerSourceAssociations.add(association);
            }
        }
        return callerSourceAssociations;
    }

    BulkResponse filterAssociationsByConfirmationState(BulkResponse br, Boolean callerIsConfirmed, Boolean otherIsConfirmed, Collection fromKeysOwned, Collection toKeysOwned) throws JAXRException {
        BulkResponseImpl filteredResponse = new BulkResponseImpl();
        ArrayList filteredAssociations = new ArrayList();
        Collection associations = br.getCollection();
        Iterator associationIter = associations.iterator();
        Collection callerFromKeys = fromKeysOwned;
        Collection callerToKeys = toKeysOwned;
        Collection callerIsSource = this.getCallerSourceAssociations(associations, callerFromKeys);
        Collection callerIsTarget = this.getCallerTargetAssociations(associations, callerToKeys);
        Collection resultSourceAssociations = this.getCallerIsSourceByState(callerIsSource, callerIsConfirmed, otherIsConfirmed);
        Collection resultTargetAssociations = this.getCallerIsTargetByState(callerIsTarget, callerIsConfirmed, otherIsConfirmed);
        if (resultSourceAssociations != null && resultSourceAssociations.size() != 0) {
            filteredAssociations.addAll(resultSourceAssociations);
        }
        if (resultTargetAssociations != null && resultTargetAssociations.size() != 0) {
            filteredAssociations.addAll(resultTargetAssociations);
        }
        filteredResponse.setPartialResponse(br.isPartialResponse());
        filteredResponse.setStatus(br.getStatus());
        filteredResponse.addCollection(filteredAssociations);
        return filteredResponse;
    }

    BulkResponse filterByAssociationTypes(BulkResponse br, Collection associationTypes) throws JAXRException {
        if (associationTypes == null) {
            return null;
        }
        BulkResponseImpl filteredResponse = new BulkResponseImpl();
        ArrayList<Association> filteredAssociations = new ArrayList<Association>();
        Collection associations = br.getCollection();
        Iterator associationIter = associations.iterator();
        for (Concept type : associationTypes) {
            while (associationIter.hasNext()) {
                Association association = (Association)associationIter.next();
                Concept associationType = association.getAssociationType();
                if (associationType == null || !associationType.getValue().equalsIgnoreCase(type.getValue())) continue;
                filteredAssociations.add(association);
            }
        }
        filteredResponse.setPartialResponse(br.isPartialResponse());
        filteredResponse.setStatus(br.getStatus());
        filteredResponse.addCollection(filteredAssociations);
        return filteredResponse;
    }

    BulkResponse filterAssociations(BulkResponse br, int criteria, String sourceKeyId, String targetKeyId) throws JAXRException {
        BulkResponseImpl filteredResponse = new BulkResponseImpl();
        ArrayList<Association> filteredAssociations = new ArrayList<Association>();
        Collection associations = br.getCollection();
        for (Association association : associations) {
            RegistryObject sourceObject = association.getSourceObject();
            RegistryObject targetObject = association.getTargetObject();
            String sourceId = sourceObject.getKey().getId();
            String targetId = targetObject.getKey().getId();
            switch (criteria) {
                case 100: {
                    if (!sourceId.equals(sourceKeyId)) break;
                    filteredAssociations.add(association);
                    break;
                }
                case 200: {
                    if (!targetId.equals(targetKeyId)) break;
                    filteredAssociations.add(association);
                    break;
                }
                case 300: {
                    if (!sourceId.equals(sourceKeyId) || !targetId.equals(targetKeyId)) break;
                    filteredAssociations.add(association);
                    break;
                }
            }
        }
        filteredResponse.setPartialResponse(br.isPartialResponse());
        filteredResponse.setStatus(br.getStatus());
        filteredResponse.addCollection(filteredAssociations);
        return filteredResponse;
    }

    BulkResponse cullDuplicates(BulkResponse br) throws JAXRException {
        Collection list = br.getCollection();
        if (list.isEmpty()) {
            return br;
        }
        Collection result = this.cullDuplicates(list);
        ((BulkResponseImpl)br).setCollection(result);
        return br;
    }

    Collection cullDuplicates(Collection list) throws JAXRException {
        HashMap<String, RegistryObject> map = new HashMap<String, RegistryObject>(list.size() * 2 - 1);
        for (RegistryObject registryObject : list) {
            String key = registryObject.getKey().getId().toUpperCase();
            if (!map.containsKey(key)) {
                map.put(key, registryObject);
                continue;
            }
            this.logger.finest("Found a dup of " + key);
            RegistryObject dupRegistryObject = (RegistryObject)map.get(key);
            if (!(registryObject instanceof ClassificationScheme) || !(dupRegistryObject instanceof ClassificationScheme)) continue;
            this.logger.finest("Both RO's are classificationSchemes");
            if (((ClassificationScheme)registryObject).isExternal()) {
                this.logger.finest("registryObject is external - don't keep it");
                continue;
            }
            this.logger.finest("RegistryObject is internal - remove dup - keep internal ro");
            map.remove(key);
            map.put(key, registryObject);
        }
        return map.values();
    }

    BulkResponse extractRegistryObjectByClass(BulkResponse br, String type) throws JAXRException {
        ArrayList<RegistryObject> robjs = new ArrayList<RegistryObject>();
        if (br.getExceptions() == null) {
            Collection ros = br.getCollection();
            for (RegistryObject ro : ros) {
                if (type.equals("Concept")) {
                    if (!(ro instanceof Concept)) continue;
                    robjs.add(ro);
                    continue;
                }
                if (!type.equals("ClassificationScheme") || !(ro instanceof ClassificationScheme)) continue;
                robjs.add(ro);
            }
            ((BulkResponseImpl)br).setCollection(robjs);
        }
        return br;
    }

    Collection getAllServiceBindingsFromOrganizations(Collection orgs) throws JAXRException {
        ArrayList bindings = new ArrayList();
        Collection services = this.getAllServicesFromOrganizations(orgs);
        for (ServiceImpl service : services) {
            Collection sbindings = service.getServiceBindings();
            bindings.addAll(sbindings);
        }
        return bindings;
    }

    Collection getAllServicesFromOrganizations(Collection orgs) throws JAXRException {
        ArrayList services = new ArrayList();
        for (OrganizationImpl org : orgs) {
            Collection orgsServices = org.getServices();
            services.addAll(orgsServices);
        }
        return services;
    }

    URLType parseUrlForUrlType(String accessUri) {
        URLType urlType = null;
        urlType = accessUri.indexOf("https") != -1 || accessUri.indexOf("HTTPS") != -1 ? URLType.HTTPS : (accessUri.indexOf("http") != -1 || accessUri.indexOf("HTTP") != -1 ? URLType.HTTP : (accessUri.indexOf("ftp") != -1 || accessUri.indexOf("FTP") != -1 ? URLType.FTP : (accessUri.indexOf("phone") != -1 || accessUri.indexOf("PHONE") != -1 ? URLType.PHONE : (accessUri.indexOf("mailto") != -1 || accessUri.indexOf("MAILTO") != -1 ? URLType.MAILTO : URLType.OTHER))));
        return urlType;
    }

    Collection getCallerSourceAssociations(Collection associations, Collection callerFromKeys) throws JAXRException {
        ArrayList<Association> callerSourceAssociations = new ArrayList<Association>();
        for (Association association : associations) {
            RegistryObject sourceObject = association.getSourceObject();
            if (sourceObject == null) continue;
            String sourceId = sourceObject.getKey().getId();
            for (String fromKey : callerFromKeys) {
                if (!fromKey.equalsIgnoreCase(sourceId)) continue;
                callerSourceAssociations.add(association);
            }
        }
        return callerSourceAssociations;
    }
}

