/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.TransformRecord;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016JF\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildOperationRecords", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "getBuildOperationRecords$kotlin_gradle_plugin_common", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "failureMessages", "", "getFailureMessages$kotlin_gradle_plugin_common", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "taskPathToMetricsReporter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "taskPathToTaskClass", "addTask", "", "taskPath", "taskClass", "Ljava/lang/Class;", "metricsReporter", "addTransformMetrics", "transformPath", "transformClass", "isKotlinTransform", "", "startTimeMs", "", "totalTimeMs", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "failureMessage", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "kotlin-gradle-plugin_common"})
public abstract class BuildMetricsService
implements BuildService<BuildServiceParameters.None>,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final ConcurrentLinkedQueue<BuildOperationRecord> buildOperationRecords = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<String> failureMessages = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentHashMap<String, BuildMetricsReporter> taskPathToMetricsReporter = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> taskPathToTaskClass = new ConcurrentHashMap();
    @NotNull
    private static final Class<BuildMetricsService> serviceClass = BuildMetricsService.class;
    @NotNull
    private static final String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();

    @NotNull
    public final ConcurrentLinkedQueue<BuildOperationRecord> getBuildOperationRecords$kotlin_gradle_plugin_common() {
        return this.buildOperationRecords;
    }

    @NotNull
    public final ConcurrentLinkedQueue<String> getFailureMessages$kotlin_gradle_plugin_common() {
        return this.failureMessages;
    }

    public void addTask(@NotNull String taskPath, @NotNull Class<?> taskClass, @NotNull BuildMetricsReporter metricsReporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter(taskClass, (String)"taskClass");
        Intrinsics.checkNotNullParameter((Object)metricsReporter, (String)"metricsReporter");
        Object it = object = this.taskPathToMetricsReporter.put(taskPath, metricsReporter);
        boolean bl = false;
        if (it != null) {
            this.log.warn("Duplicate task path: " + taskPath);
        }
        object = this.taskPathToTaskClass.put(taskPath, taskClass.getName());
        it = (String)object;
        boolean bl2 = false;
        if (it != null) {
            this.log.warn("Duplicate task path: " + taskPath);
        }
    }

    public void addTransformMetrics(@NotNull String transformPath, @NotNull Class<?> transformClass, boolean isKotlinTransform, long startTimeMs, long totalTimeMs, @NotNull BuildMetrics buildMetrics, @Nullable String failureMessage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)transformPath, (String)"transformPath");
            Intrinsics.checkNotNullParameter(transformClass, (String)"transformClass");
            Intrinsics.checkNotNullParameter((Object)buildMetrics, (String)"buildMetrics");
            String string = transformClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transformClass.name");
            this.buildOperationRecords.add(new TransformRecord(transformPath, string, isKotlinTransform, startTimeMs, totalTimeMs, buildMetrics));
            String string2 = failureMessage;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.failureMessages.add(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            String string;
            Object it;
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long totalTimeMs = result2.getEndTime() - result2.getStartTime();
            BuildMetrics buildMetrics = new BuildMetrics(null, null, null, 7, null);
            buildMetrics.getBuildTimes().addTimeMs(BuildTime.GRADLE_TASK, totalTimeMs);
            BuildMetricsReporter buildMetricsReporter = this.taskPathToMetricsReporter.get(taskPath);
            if (buildMetricsReporter != null) {
                it = buildMetricsReporter;
                boolean bl = false;
                buildMetrics.addAll(it.getMetrics());
            }
            Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
            TaskExecutionResult taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
            TaskExecutionResult taskExecutionResult2 = taskExecutionResult;
            if (taskExecutionResult2 != null && (taskExecutionResult2 = taskExecutionResult2.getBuildMetrics()) != null) {
                Object it2 = it = taskExecutionResult2;
                boolean bl = false;
                buildMetrics.addAll((BuildMetrics)it2);
            }
            if ((string = this.taskPathToTaskClass.get(taskPath)) == null) {
                string = "unknown";
            }
            long l = result2.getStartTime();
            boolean bl = result2 instanceof org.gradle.tooling.events.task.TaskExecutionResult;
            TaskSkippedResult taskSkippedResult = result2 instanceof TaskSkippedResult ? (TaskSkippedResult)result2 : null;
            String string2 = taskSkippedResult != null ? taskSkippedResult.getSkipMessage() : null;
            Object object = taskExecutionResult;
            if (object == null || (object = ((TaskExecutionResult)object).getIcLogLines()) == null) {
                object = CollectionsKt.emptyList();
            }
            this.buildOperationRecords.add(new TaskRecord(taskPath, string, l, totalTimeMs, buildMetrics, bl, string2, (List<String>)object));
            if (result2 instanceof TaskFailureResult) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = ((TaskFailureResult)result2).getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"result.failures");
                Iterable iterable = list2;
                ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.failureMessages;
                boolean $i$f$map = false;
                void it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    Failure failure = (Failure)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it3.getMessage());
                }
                concurrentLinkedQueue.addAll((List)destination$iv$iv);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService$Companion;", "", "()V", "serviceClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsService;", "serviceName", "", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Provider<BuildMetricsService> registerIfAbsent(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider = it.getService();
                Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.report.BuildMetricsService>");
                return provider;
            }
            Project project2 = project.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project2);
            if (reportingSettings.getBuildReportOutputs().isEmpty()) {
                return null;
            }
            Function1 function1 = registerIfAbsent.2.INSTANCE;
            Provider provider = project.getGradle().getSharedServices().registerIfAbsent(serviceName, serviceClass, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNull((Object)provider);
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

