/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTupleImpl;

public final class ForEachUniNode<A>
extends AbstractNode {
    private final Class<A> forEachClass;
    private final TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle;
    private final int outputStoreSize;
    private final Map<A, UniTupleImpl<A>> tupleMap = new IdentityHashMap<A, UniTupleImpl<A>>(1000);
    private final Queue<UniTupleImpl<A>> dirtyTupleQueue;

    public ForEachUniNode(Class<A> forEachClass, TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle, int outputStoreSize) {
        this.forEachClass = forEachClass;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.outputStoreSize = outputStoreSize;
        this.dirtyTupleQueue = new ArrayDeque<UniTupleImpl<A>>(1000);
    }

    public void insert(A a) {
        UniTupleImpl<A> tuple = new UniTupleImpl<A>(a, this.outputStoreSize);
        UniTupleImpl<A> old = this.tupleMap.put(a, tuple);
        if (old != null) {
            throw new IllegalStateException("The fact (" + a + ") was already inserted, so it cannot insert again.");
        }
        this.dirtyTupleQueue.add(tuple);
    }

    public void update(A a) {
        UniTupleImpl<A> tuple = this.tupleMap.get(a);
        if (tuple == null) {
            throw new IllegalStateException("The fact (" + a + ") was never inserted, so it cannot update.");
        }
        if (tuple.state.isDirty()) {
            if (tuple.state == BavetTupleState.DYING || tuple.state == BavetTupleState.ABORTING) {
                throw new IllegalStateException("The fact (" + a + ") was retracted, so it cannot update.");
            }
        } else {
            tuple.state = BavetTupleState.UPDATING;
            this.dirtyTupleQueue.add(tuple);
        }
    }

    public void retract(A a) {
        UniTupleImpl<A> tuple = this.tupleMap.remove(a);
        if (tuple == null) {
            throw new IllegalStateException("The fact (" + a + ") was never inserted, so it cannot retract.");
        }
        if (tuple.state.isDirty()) {
            if (tuple.state == BavetTupleState.DYING || tuple.state == BavetTupleState.ABORTING) {
                throw new IllegalStateException("The fact (" + a + ") was already retracted, so it cannot retract.");
            }
            tuple.state = BavetTupleState.ABORTING;
        } else {
            tuple.state = BavetTupleState.DYING;
            this.dirtyTupleQueue.add(tuple);
        }
    }

    @Override
    public void calculateScore() {
        block6: for (UniTupleImpl uniTupleImpl : this.dirtyTupleQueue) {
            switch (uniTupleImpl.state) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(uniTupleImpl);
                    uniTupleImpl.state = BavetTupleState.OK;
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(uniTupleImpl);
                    uniTupleImpl.state = BavetTupleState.OK;
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(uniTupleImpl);
                    uniTupleImpl.state = BavetTupleState.DEAD;
                    continue block6;
                }
                case ABORTING: {
                    uniTupleImpl.state = BavetTupleState.DEAD;
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + uniTupleImpl + ") in node (" + this + ") is in an unexpected state (" + uniTupleImpl.state + ").");
        }
        this.dirtyTupleQueue.clear();
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.forEachClass.getSimpleName() + ")";
    }

    public Class<A> getForEachClass() {
        return this.forEachClass;
    }
}

