package org.openqa.selenium.devtools.v126.extensions;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Defines commands and events for browser extensions. Available if the client
 * is connected using the --remote-debugging-pipe flag and
 * the --enable-unsafe-extension-debugging flag is set.
 */
@Beta()
public class Extensions {

    /**
     * Installs an unpacked extension from the filesystem similar to
     * --load-extension CLI flags. Returns extension ID once the extension
     * has been installed.
     */
    public static Command<java.lang.String> loadUnpacked(java.lang.String path) {
        java.util.Objects.requireNonNull(path, "path is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("path", path);
        return new Command<>("Extensions.loadUnpacked", Map.copyOf(params), ConverterFunctions.map("id", java.lang.String.class));
    }
}
