package org.openqa.selenium.devtools.v127.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class RelatedApplication {

    private final java.util.Optional<java.lang.String> id;

    private final java.lang.String url;

    public RelatedApplication(java.util.Optional<java.lang.String> id, java.lang.String url) {
        this.id = id;
        this.url = java.util.Objects.requireNonNull(url, "url is required");
    }

    public java.util.Optional<java.lang.String> getId() {
        return id;
    }

    public java.lang.String getUrl() {
        return url;
    }

    private static RelatedApplication fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> id = java.util.Optional.empty();
        java.lang.String url = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "url":
                    url = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RelatedApplication(id, url);
    }
}
