/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.emulation.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum PressureState {
    NOMINAL("nominal"),
    FAIR("fair"),
    SERIOUS("serious"),
    CRITICAL("critical");

    private String value;

    private PressureState(String value) {
        this.value = value;
    }

    public static PressureState fromString(String s) {
        return Arrays.stream(PressureState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PressureState "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PressureState fromJson(JsonInput input) {
        return PressureState.fromString(input.nextString());
    }
}

