/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.boot.test.autoconfigure.filter.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.web.client.RestClientTest;
import org.springframework.util.ClassUtils;

public final class RestClientTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<RestClientTest> {
    private static final Class<?>[] NO_COMPONENTS = new Class[0];
    private static final String DATABIND_MODULE_CLASS_NAME = "com.fasterxml.jackson.databind.Module";
    private static final Set<Class<?>> DEFAULT_INCLUDES;
    private final Class<?>[] components = this.getAnnotation().getValue("components", Class[].class).orElse(NO_COMPONENTS);

    RestClientTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    @Override
    protected Set<Class<?>> getDefaultIncludes() {
        return DEFAULT_INCLUDES;
    }

    @Override
    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.components));
    }

    static {
        LinkedHashSet includes = new LinkedHashSet();
        if (ClassUtils.isPresent((String)DATABIND_MODULE_CLASS_NAME, (ClassLoader)RestClientTypeExcludeFilter.class.getClassLoader())) {
            try {
                includes.add(Class.forName(DATABIND_MODULE_CLASS_NAME, true, RestClientTypeExcludeFilter.class.getClassLoader()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Failed to load com.fasterxml.jackson.databind.Module", ex);
            }
            includes.add(JsonComponent.class);
        }
        DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
    }
}

