/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public abstract class AbstractFailureAnalyzer<T extends Throwable>
implements FailureAnalyzer {
    @Override
    public @Nullable FailureAnalysis analyze(Throwable failure) {
        T cause = this.findCause(failure, this.getCauseType());
        return cause != null ? this.analyze(failure, cause) : null;
    }

    protected abstract @Nullable FailureAnalysis analyze(Throwable var1, T var2);

    protected Class<? extends T> getCauseType() {
        Class type = ResolvableType.forClass(AbstractFailureAnalyzer.class, this.getClass()).resolveGeneric(new int[0]);
        Assert.state((type != null ? 1 : 0) != 0, (String)"Unable to resolve generic");
        return type;
    }

    protected final <E extends Throwable> @Nullable E findCause(@Nullable Throwable failure, Class<E> type) {
        while (failure != null) {
            if (type.isInstance(failure)) {
                return (E)failure;
            }
            failure = failure.getCause();
        }
        return null;
    }
}

