/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.bson.Document;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.MongoRegexCreator;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.UntypedExampleMatcher;
import org.springframework.data.mongodb.util.DotPath;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoExampleMapper {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoConverter converter;

    public MongoExampleMapper(MongoConverter converter) {
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public Document getMappedExample(Example<?> example) {
        Assert.notNull(example, (String)"Example must not be null");
        return this.getMappedExample(example, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(example.getProbeType()));
    }

    public Document getMappedExample(Example<?> example, MongoPersistentEntity<?> entity) {
        Object identifier;
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull(entity, (String)"MongoPersistentEntity must not be null");
        Document reference = (Document)this.converter.convertToMongoType(example.getProbe());
        if (entity.getIdProperty() != null && ClassUtils.isAssignable((Class)entity.getType(), (Class)example.getProbeType()) && (identifier = entity.getIdentifierAccessor(example.getProbe()).getIdentifier()) == null) {
            reference.remove((Object)((MongoPersistentProperty)entity.getIdProperty()).getFieldName());
        }
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        this.applyPropertySpecs("", reference, example.getProbeType(), matcherAccessor);
        Document flattened = ObjectUtils.nullSafeEquals((Object)ExampleMatcher.NullHandler.INCLUDE, (Object)matcherAccessor.getNullHandler()) ? reference : new Document(SerializationUtils.flattenMap(reference));
        Document result = example.getMatcher().isAllMatching() ? flattened : MongoExampleMapper.orConcatenate(flattened);
        return this.updateTypeRestrictions(result, example);
    }

    private void applyPropertySpecs(String path, Document source, Class<?> probeType, ExampleMatcherAccessor exampleSpecAccessor) {
        if (source == null) {
            return;
        }
        Iterator iter = source.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String propertyPath = DotPath.from(path).append((String)entry.getKey()).toString();
            String mappedPropertyPath = this.getMappedPropertyPath(propertyPath, probeType);
            if (MongoExampleMapper.isEmptyIdProperty(entry)) {
                iter.remove();
                continue;
            }
            if (exampleSpecAccessor.isIgnoredPath(propertyPath) || exampleSpecAccessor.isIgnoredPath(mappedPropertyPath)) {
                iter.remove();
                continue;
            }
            ExampleMatcher.StringMatcher stringMatcher = exampleSpecAccessor.getDefaultStringMatcher();
            Object value = entry.getValue();
            boolean ignoreCase = exampleSpecAccessor.isIgnoreCaseEnabled();
            if (exampleSpecAccessor.hasPropertySpecifiers()) {
                mappedPropertyPath = exampleSpecAccessor.hasPropertySpecifier(propertyPath) ? propertyPath : this.getMappedPropertyPath(propertyPath, probeType);
                stringMatcher = exampleSpecAccessor.getStringMatcherForPath(mappedPropertyPath);
                ignoreCase = exampleSpecAccessor.isIgnoreCaseForPath(mappedPropertyPath);
            }
            if (exampleSpecAccessor.hasPropertySpecifier(mappedPropertyPath)) {
                ExampleMatcher.PropertyValueTransformer valueTransformer = exampleSpecAccessor.getValueTransformerForPath(mappedPropertyPath);
                Optional converted = (Optional)valueTransformer.apply(Optional.ofNullable(value));
                if (!converted.isPresent()) {
                    iter.remove();
                    continue;
                }
                entry.setValue(converted.get());
            }
            if (entry.getValue() instanceof String) {
                MongoExampleMapper.applyStringMatcher(entry, stringMatcher, ignoreCase);
                continue;
            }
            if (!(entry.getValue() instanceof Document)) continue;
            this.applyPropertySpecs(propertyPath, (Document)entry.getValue(), probeType, exampleSpecAccessor);
        }
    }

    private String getMappedPropertyPath(String path, Class<?> probeType) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(probeType);
        Iterator<String> parts = Arrays.asList(path.split("\\.")).iterator();
        Stack stack = new Stack();
        ArrayList<String> resultParts = new ArrayList<String>();
        while (parts.hasNext()) {
            String part = parts.next();
            MongoPersistentProperty prop = (MongoPersistentProperty)entity.getPersistentProperty(part);
            if (prop == null) {
                entity.doWithProperties(property -> {
                    if (property.getFieldName().equals(part)) {
                        stack.push(property);
                    }
                });
                if (stack.isEmpty()) {
                    return "";
                }
                prop = (MongoPersistentProperty)stack.pop();
            }
            resultParts.add(prop.getName());
            if (!prop.isEntity() || !this.mappingContext.hasPersistentEntityFor(prop.getActualType())) break;
            entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(prop.getActualType());
        }
        return StringUtils.collectionToDelimitedString(resultParts, (String)".");
    }

    private Document updateTypeRestrictions(Document query, Example example) {
        Document result = new Document();
        if (this.isTypeRestricting(example)) {
            result.putAll((Map)query);
            this.converter.getTypeMapper().writeTypeRestrictions(result, this.getTypesToMatch(example));
            return result;
        }
        for (Map.Entry entry : query.entrySet()) {
            if (this.converter.getTypeMapper().isTypeKey((String)entry.getKey())) continue;
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    private boolean isTypeRestricting(Example example) {
        if (example.getMatcher() instanceof UntypedExampleMatcher) {
            return false;
        }
        if (example.getMatcher().getIgnoredPaths().isEmpty()) {
            return true;
        }
        for (String path : example.getMatcher().getIgnoredPaths()) {
            if (!this.converter.getTypeMapper().isTypeKey(path)) continue;
            return false;
        }
        return true;
    }

    private Set<Class<?>> getTypesToMatch(Example<?> example) {
        HashSet types = new HashSet();
        for (TypeInformation reference : this.mappingContext.getManagedTypes()) {
            if (!example.getProbeType().isAssignableFrom(reference.getType())) continue;
            types.add(reference.getType());
        }
        return types;
    }

    private static boolean isEmptyIdProperty(Map.Entry<String, Object> entry) {
        return entry.getKey().equals("_id") && (entry.getValue() == null || entry.getValue().equals(Optional.empty()));
    }

    private static void applyStringMatcher(Map.Entry<String, Object> entry, ExampleMatcher.StringMatcher stringMatcher, boolean ignoreCase) {
        Document document = new Document();
        if (ExampleMatcher.StringMatcher.DEFAULT == stringMatcher) {
            if (ignoreCase) {
                document.put("$regex", (Object)Pattern.quote((String)entry.getValue()));
                entry.setValue(document);
            }
        } else {
            String expression = MongoRegexCreator.INSTANCE.toRegularExpression((String)entry.getValue(), MongoExampleMapper.toMatchMode(stringMatcher));
            document.put("$regex", (Object)expression);
            entry.setValue(document);
        }
        if (ignoreCase) {
            document.put("$options", (Object)"i");
        }
    }

    private static Document orConcatenate(Document source) {
        ArrayList<Document> or = new ArrayList<Document>(source.keySet().size());
        for (String key : source.keySet()) {
            or.add(new Document(key, source.get((Object)key)));
        }
        return new Document("$or", or);
    }

    private static MongoRegexCreator.MatchMode toMatchMode(ExampleMatcher.StringMatcher matcher) {
        switch (matcher) {
            case CONTAINING: {
                return MongoRegexCreator.MatchMode.CONTAINING;
            }
            case STARTING: {
                return MongoRegexCreator.MatchMode.STARTING_WITH;
            }
            case ENDING: {
                return MongoRegexCreator.MatchMode.ENDING_WITH;
            }
            case EXACT: {
                return MongoRegexCreator.MatchMode.EXACT;
            }
            case REGEX: {
                return MongoRegexCreator.MatchMode.REGEX;
            }
        }
        return MongoRegexCreator.MatchMode.DEFAULT;
    }
}

