/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CacheInterceptor
extends CacheAspectSupport
implements MethodInterceptor,
Serializable {
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        CacheOperationInvoker aopAllianceInvoker = () -> {
            try {
                if (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isSuspendingFunction((Method)method)) {
                    return KotlinDelegate.invokeSuspendingFunction(method, invocation.getThis(), invocation.getArguments());
                }
                return invocation.proceed();
            }
            catch (Throwable ex) {
                throw new CacheOperationInvoker.ThrowableWrapper(ex);
            }
        };
        Object target = invocation.getThis();
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        try {
            return this.execute(aopAllianceInvoker, target, method, invocation.getArguments());
        }
        catch (CacheOperationInvoker.ThrowableWrapper th) {
            throw th.getOriginal();
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static Publisher<?> invokeSuspendingFunction(Method method, @Nullable Object target, Object ... args) {
            Continuation continuation = (Continuation)args[args.length - 1];
            CoroutineContext coroutineContext = continuation.getContext().minusKey((CoroutineContext.Key)Job.Key);
            return CoroutinesUtils.invokeSuspendingFunction((CoroutineContext)coroutineContext, (Method)method, (Object)target, (Object[])args);
        }
    }
}

